/*
*
* Copyright (C) 2004 Mekensleep
*
*	Mekensleep
*	24 rue vieille du temple
*	75004 Paris
*       licensing@mekensleep.com
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*
* Authors:
*  Igor Kravtchenko <igor@obraz.net>
*
* Description:
* Precis clock to count ellapsed time.
* The clock's granularity is as precis as possible and thus can be
* massively used without worry for anything that requires precis timestep.
* The implementation uses the Cedric's timer class.
*/

#include "mafStdAfx.h"

#ifndef USE_VS_PCH
#include <maf/clock.h>
#endif

#include <maf/timer.h>

MAFClock::MAFClock()
{
	reset();
	bHalted_ = true;
	bReverse_ = false;
	mul_ = 1;
}

MAFClock::~MAFClock()
{
}

void MAFClock::reset()
{
	startCounter_ = GetRealTime();
	lastTime_ = 0.0f;
}

float MAFClock::elapsed() const
{
	if (bHalted_ == true)
		return lastTime_;
	else {
		float time = GetRealTime() - startCounter_;
		time *= mul_;
		if (bReverse_ == true)
			return lastTime_ - time;
		else
			return lastTime_ + time;
	}
}

void MAFClock::pause()
{
	if (bHalted_ == false) {
		lastTime_ = elapsed();
		bHalted_ = true;
	}
	else {
		bHalted_ = false;
		startCounter_ = GetRealTime();
	}
}

void MAFClock::set(float time)
{
	reset();
	lastTime_ = time;
}
