/**
    Copyright (C) 2004 Cedric Pinson <cpinson@freesheep.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 ****************************************************************************
 * @file   exg_material.cxx
 *
 * @brief   base for material exchange
 *
 *****************************************************************************
 *
 * @author  Cedric Pinson
 *
 * @date    Created 2001/04
 *
 * @version $Id: exg_material.cpp,v 1.1 2004/10/06 15:05:46 izidor79 Exp $
 *
 ****************************************************************************/

#include <exg/exg.h>
#include <exg/exg_material.h>
#include <exg/exg_polygon.h>
#include <exg/exg_visitor.h>

namespace exg
{

  /**
   * Register a polygon to a material.
   *
   * @param Polygon* to add to this material
   */
  void Material::AddPolygon(Polygon* polygon) 
  { 
    std::vector<Pointer<Polygon> >::iterator i = std::find(mPolygons.begin(), mPolygons.end(), polygon);
    if(i == mPolygons.end())
      mPolygons.push_back(polygon);
    if(polygon->GetMaterial() != this)
      polygon->SetMaterial(this);
    return;
  }


  void Material::Traverse(Visitor& visitor)
  {
    int nb=GetNbPolygons();
    //    std::cout << "Traverse material with " << this << " " << nb << std::endl;
    for (int i=0;i<nb;i++)
      GetPolygon(i)->Accept(visitor);
  }

  std::ostream& Material::operator<<(std::ostream& o)
  {
    Indent(indent-1,o);
    o << "Material\n";
    return MapObjectPointer::operator<<(o);
  }

  void Material::ORepair(IOContext* context) {
    for(std::map<int, Pointer<Object> >::iterator i = context->mSerial2Object.begin();
	i != context->mSerial2Object.end();
	i++) {

      if(i->second == 0)
	continue;

      switch(i->second->GetType()) {
      case Object::POLYGON:
	{
	  Polygon* polygon = i->second->AsPolygon();
	  if(polygon->GetMaterial() == this)
	    mPolygons.push_back(polygon);
	}
	break;
      default:
	break;
      }
    }
  }
}
