#!/usr/bin/perl -w

#   Validates an XML document
#
#   Copyright (C) 2001 Guillaume Morin, Alcve
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
#   $Id: xml-validate.pl,v 1.1 2004/01/31 12:38:22 loic Exp $
#   $Date: 2004/01/31 12:38:22 $
#   $Author: loic $

use strict;
use XML::Xerces;

my $parser = XML::Xerces::XercesDOMParser->new();
$parser->setValidationScheme($XML::Xerces::AbstractDOMParser::Val_Always);
$parser->setDoNamespaces(1);
$parser->setDoSchema (1);
$parser->setErrorHandler(XML::Xerces::PerlErrorHandler->new);

$parser->parse (XML::Xerces::LocalFileInputSource->new($ARGV[0]));

print($ARGV[0]. " validated with the corresponding xml schema\n");

__END__
