/* *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Henry Prcheur <henry at precheur dot org>
 *
 */

#include <gtk/gtk.h>
#include <glade/glade.h>
#include "gui.h"
#include "network.h"

static GtkWidget*	g_user_info_window;
static GtkWidget*	g_user_info_vbox;
static GladeXML*	g_glade_user_info_xml = 0;

gboolean cashier_visible = FALSE;
void refresh_top_menu(void);

static void	close_callback(GtkWidget* w, gpointer data)
{
  g_assert(GTK_IS_LABEL(w));
  g_assert(GTK_IS_CONTAINER(data));

  gtk_container_remove(GTK_CONTAINER(data), w);
}

void	close_user_info(void)
{
  g_message("close user info");
  gtk_container_foreach(GTK_CONTAINER(g_user_info_vbox), close_callback, g_user_info_vbox);
  set_string("user_info");
  flush_io_channel();
  gtk_widget_hide_all(g_user_info_window);
  cashier_visible = FALSE; refresh_top_menu();
}

void	on_user_info_closebutton_clicked(GtkWidget* widget, gpointer user_data)
{
  (void) widget;
  (void) user_data;

  close_user_info();
}

int	handle_user_info()
{
  if (!g_glade_user_info_xml)
    {
      g_glade_user_info_xml = gui_load_widget("user_info_window");
      if (!g_glade_user_info_xml)
	return FALSE;
      g_user_info_window = glade_xml_get_widget(g_glade_user_info_xml,
						"user_info_window");
      g_assert(g_user_info_window);
      g_user_info_vbox = glade_xml_get_widget(g_glade_user_info_xml,
					      "user_info_vbox");
      g_assert(g_user_info_vbox);
      GUI_BRANCH(g_glade_user_info_xml, on_user_info_closebutton_clicked);
    }

  int	i = get_int();
  g_message("%d", i);
  while (i--)
    {
      char*	str = get_string();
/*       g_message("%s", str); */
      gtk_box_pack_start_defaults(GTK_BOX(g_user_info_vbox),
				  gtk_label_new(str));
    }
  
  gui_center_window(GTK_WINDOW(g_user_info_window));
  cashier_visible = TRUE; refresh_top_menu();
  return TRUE;
}
