/* *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Henry Prcheur <henry@precheur.org>
 *  Cedric Pinson <cpinson@freesheep.org>
 */

#include <string.h>
#include <gtk/gtk.h>
#include <glade/glade.h>
#include "gui.h"
#include "network.h"

static GtkWidget* g_outfit_window;
static GtkWidget* g_outfit_scrolled_window;
static GtkWidget* g_outfit_tree;
static GtkWidget* g_outfit_label;
static GtkWidget* g_outfit_frame;
static GtkWidget* g_outfit_horizontal_buttons;
static GtkWidget* g_outfit_vertical_box;
static GtkWidget* g_outfit_ok;
static GtkWidget* g_outfit_cancel;
static GladeXML* g_glade_outfit_xml = 0;
static GtkListStore* g_outfit_mylist=0;

char* outfit_visible = 0;

static void notify_caller_quit(void)
{
  g_message("quit outfit");
  set_string("outfit");
  set_string("quit");
  set_string("none");
  flush_io_channel();
}

void close_outfit(void)
{
  gtk_widget_hide_all(g_outfit_window);
  g_free(outfit_visible);  
  outfit_visible = 0; 
}

void on_cancel_outfit_clicked(GtkWidget *widget, gpointer user_data)
{
  (void) widget;
  (void) user_data;

  notify_caller_quit();
  close_outfit();
}

static void send_item(char* item)
{
  g_message("outfit %s", item);
  set_string("outfit");
  set_string("select");
  set_string(item);
  flush_io_channel();
  close_outfit();
}

void on_ok_outfit_clicked(GtkWidget *widget, gpointer user_data)
{
  (void) widget;
  (void) user_data;

  GtkTreeSelection* selection;
  GtkTreeModel*	model;
  GtkTreeIter	iter;

  /* This will only work in single or browse selection mode! */
  model = gtk_tree_view_get_model(GTK_TREE_VIEW(widget));
  selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(widget));
  if (gtk_tree_selection_get_selected(selection, &model, &iter)) {
    gchar* item=0;
    gtk_tree_model_get (model, &iter, 0, &item, -1);
    send_item(item);
    g_free(item);
  } else
    g_message("no row selected.\n");
}



static void fill_list(GtkListStore* list_store)
{
  int	list_size = get_int();
  int	i;

  g_message("list_size %d", list_size);
  for (i = 0; i < list_size; i++) {
    GtkTreeIter iter;
    g_message("new row");
    gtk_list_store_append(list_store, &iter);

    char* str = get_string();
    g_message("string: %s", str);
    //    gtk_list_store_set_value(list_store, &iter, 0, &value);
    gtk_list_store_set (list_store, &iter,
			0, str,
			-1);
    g_free(str);
  }
  g_message("%s return", __FUNCTION__);
}



static void on_row_activated(GtkTreeView *treeview,GtkTreePath *path,GtkTreeViewColumn *col,gpointer user_data)
{
  (void) col;
  (void) user_data;

  g_message("row clicked");
  GtkTreeModel*	model;
  GtkTreeIter iter;
  
  model = gtk_tree_view_get_model(treeview);
  if (gtk_tree_model_get_iter(model, &iter, path)) {
    int id;
    gchar* item=0;
    gtk_tree_model_get(model, &iter, 0, &item, -1);
    g_message("Double-clicked row contains %s", item);
    send_item(item);
    g_free(item);
  } else
    g_warning("unable to find active row");
}


int handle_outfit(void)
{
  if (!g_glade_outfit_xml) {
    g_glade_outfit_xml = gui_load_widget("outfit_window");
    if (!g_glade_outfit_xml)
      return FALSE;
    g_outfit_window = glade_xml_get_widget(g_glade_outfit_xml, "outfit_window");
    g_outfit_cancel = glade_xml_get_widget(g_glade_outfit_xml, "outfit_cancel");
    //    g_outfit_ok = glade_xml_get_widget(g_glade_outfit_xml, "outfit_ok");
    g_outfit_tree = glade_xml_get_widget(g_glade_outfit_xml, "outfit_list");

    g_signal_connect(GTK_TREE_VIEW(g_outfit_tree), "row-activated",(GCallback)on_row_activated, NULL);
    g_outfit_mylist = gtk_list_store_new (1, G_TYPE_STRING);
    fill_list(g_outfit_mylist);
    gtk_tree_view_set_model(GTK_TREE_VIEW(g_outfit_tree),GTK_TREE_MODEL (g_outfit_mylist));

    GtkCellRenderer* cell_renderer = gtk_cell_renderer_text_new(); // FIXME
    GtkTreeViewColumn* column = gtk_tree_view_column_new();
    gtk_tree_view_column_set_title(column, "Select outfit");
    gtk_tree_view_append_column(GTK_TREE_VIEW(g_outfit_tree), column);
    gtk_tree_view_column_pack_start(column, cell_renderer, TRUE);
    gtk_tree_view_column_add_attribute(column, cell_renderer, "text", 0);

    //    GUI_BRANCH(g_glade_outfit_xml, on_ok_outfit_clicked);
    GUI_BRANCH(g_glade_outfit_xml, on_cancel_outfit_clicked);


    gtk_widget_hide_all(g_outfit_window);
  }

  gui_center_window(GTK_WINDOW(g_outfit_window));
  return TRUE;
}
