/* *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Henry Prcheur <henry@precheur.org>
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <argp.h>
#include <unistd.h>
#include "network.h"

int	handle_lobby(void);
int	handle_login(void);
int	handle_message_box(void);
int	handle_yesno(void);
int	handle_chooser(void);
int	handle_user_info(void);
int	handle_slider(void);
int	handle_blind(void);
int	handle_sit_actions(void);
int	handle_future_action(void);
int	handle_in_position(void);
int	handle_buy_in(void);
int	handle_chat(void);
int	handle_top_menu(void);
int	handle_outfit(void);

/*
 * Command line parsing
 */
int	g_want_verbose;
int	g_port_number;
char*	g_display;
char*	g_hostname;
char*	g_gtk_rc_file;

static struct argp_option options[] =
{
  { "port",	'p',	"PORT-NUMBER",	0,
    "Specify port number of the server",	0 },
  { "display",	'd',	"DISPLAY",	0,
    "Display to connect to",	0 },
  { "verbose",	'v',	"VERBOSE-LEVEL",	0,
    "Print more information",	0 },
  { "gtkrc",	'r',	"GTK-RC-FILE",	0,
    "Specify gtk+2 recourse file",	0 },
  { NULL, 0, NULL, 0, NULL, 0 }
};

static void show_version (FILE *stream, struct argp_state *state)
{
  (void) state;
  fputs("poker3d-interface\n", stream);
  fprintf(stream, "Copyright (C) %s %s\n", "2004", "Mekensleep");
  fputs("\
This program is free software; you may redistribute it under the terms of\n\
the GNU General Public License.  This program has absolutely no warranty.\n",
	stream);
}

/* Parse a single option.  */
static error_t
parse_opt (int key, char *arg, struct argp_state *state)
{
  switch (key)
    {
    case ARGP_KEY_INIT:
      g_want_verbose = 0;
      g_port_number = 19379;
      g_hostname = 0;
      g_display = 0;
      g_gtk_rc_file = 0;
      break;

    case 'p':			/* --port */
      g_port_number = atoi(arg);
      break;
    case 'v':			/* --verbose */
      g_want_verbose = atoi(arg);
      break;
    case 'd':			/* --display */
      g_display = g_strdup(arg);
      break;
    case 'r':
      g_gtk_rc_file = g_strdup(arg);
      break;
    case ARGP_KEY_ARG:		/* [FILE]... */
      /* TODO: Do something with ARG, or remove this case and make
         main give argp_parse a non-NULL fifth argument.  */
      if (g_hostname)
	argp_failure (state, 1, errno,
		      "More than one hostname specified");
      else
	g_hostname = g_strdup(arg);
      break;

    default:
      return ARGP_ERR_UNKNOWN;
    }
  return 0;
}

/* The argp functions examine these global variables.  */
const char *argp_program_bug_address = "<henry@mekensleep.org>";
void (*argp_program_version_hook) (FILE *, struct argp_state *) = show_version;

static struct argp argp =
{
  options, parse_opt, "[HOSTNAME]",
  "Poker3D lobby",
  NULL, NULL, NULL
};

gboolean	handle_network(GIOChannel *source,
			       GIOCondition condition,
			       gpointer data)
{
  (void) source;
  (void) condition;
  (void) data;

  char*	string = get_string();

  if (!string)
    {
      g_warning("null packet");
      return FALSE;
    }

  g_message("received %s", string);
  if (strcmp("login", string) == 0)
    handle_login();
  else if (strcmp("message_box", string) == 0)
    handle_message_box();
  else if (strcmp("lobby", string) == 0)
    handle_lobby();
  else if (strcmp("yesno", string) == 0)
    handle_yesno();
  else if (strcmp("chooser", string) == 0)
    handle_chooser();
  else if (strcmp("user_info", string) == 0)
    handle_user_info();
  else if (strcmp("blind", string) == 0)
    handle_blind();
  else if (strcmp("sit_actions", string) == 0)
    handle_sit_actions();
  else if (strcmp("future_action", string) == 0)
    handle_future_action();
  else if (strcmp("chat", string) == 0)
    handle_chat();
  else if (strcmp("slider", string) == 0)
    handle_slider();
  else if (strcmp("buy_in", string) == 0)
    handle_buy_in();
  else if (strcmp("in_position", string) == 0)
    handle_in_position();
  else if (strcmp("top_menu", string) == 0)
    handle_top_menu();
  else if (strcmp("outfit", string) == 0)
    handle_outfit();
  else if (strcmp("quit", string) == 0)
    gtk_main_quit();
  else
    g_warning("unknown packet type: %s", string);

  g_free(string);
  return TRUE;
}

static void noLog(const gchar *log_domain,
		  GLogLevelFlags log_level,
		  const gchar *message,
		  gpointer user_data) {
  (void) log_domain;
  (void) log_level;
  (void) message;
  (void) user_data;
}

int main(int   argc,
	 char *argv[])
{
  if(setpgrp() < 0)
    perror("setpgrp()");

  if (argp_parse(&argp, argc, argv, 0, NULL, NULL) != 0)
    return 1;

  if (g_display)
    {
      char	tmp[64];
      snprintf(tmp, sizeof (tmp), "DISPLAY=%s", g_display);
      putenv(tmp);
    }

  if (g_gtk_rc_file)
    {
      char*	tmp[2] = { g_gtk_rc_file, 0 };
      gtk_rc_set_default_files(tmp);
      g_free(g_gtk_rc_file);
    }
  gtk_init (&argc, &argv);

  if(g_want_verbose == 0) {
    g_log_set_handler(NULL,
		      (GLogLevelFlags)(G_LOG_LEVEL_WARNING |
				       G_LOG_LEVEL_MESSAGE |
				       G_LOG_LEVEL_INFO |
				       G_LOG_LEVEL_DEBUG),
		      noLog, NULL);
  } else if(g_want_verbose == 1) {
    g_log_set_handler(NULL,
		      (GLogLevelFlags)(G_LOG_LEVEL_INFO |
				       G_LOG_LEVEL_DEBUG),
		      noLog, NULL);
    g_log_set_handler(NULL,
		      (GLogLevelFlags)(G_LOG_LEVEL_WARNING |
				       G_LOG_LEVEL_MESSAGE),
		      g_log_default_handler, NULL);
  } else if(g_want_verbose == 2) {
    g_log_set_handler(NULL,
		      (GLogLevelFlags)(G_LOG_LEVEL_DEBUG),
		      noLog, NULL);
    g_log_set_handler(NULL,
		      (GLogLevelFlags)(G_LOG_LEVEL_INFO |
				       G_LOG_LEVEL_WARNING |
				       G_LOG_LEVEL_MESSAGE),
		      g_log_default_handler, NULL);
  } else {
    g_log_set_handler(NULL,
		      (GLogLevelFlags)(G_LOG_LEVEL_WARNING |
				       G_LOG_LEVEL_MESSAGE |
				       G_LOG_LEVEL_INFO |
				       G_LOG_LEVEL_DEBUG),
		      g_log_default_handler, NULL);
  }

  if (!init_network(g_hostname ? g_hostname : "127.0.0.1"))
    return 1;

  gtk_main ();

  return 0;
}
