/* *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Henry Prcheur <henry at precheur dot org>
 *
 */

#include <stdio.h>
#include <string.h>
#include <glib/gprintf.h>
#include <gtk/gtk.h>
#include <glade/glade.h>
#include "gui.h"
#include "network.h"

static GtkWidget*	g_login_window;
static GtkWidget*	g_login_entry;
static GtkWidget*	g_password_entry;
static GtkWidget*	g_remember_password;
static GladeXML*	g_glade_login_xml = 0;

void	on_password_entry_activate(GtkWidget *widget, gpointer user_data)
{
  (void) widget;
  (void) user_data;

  g_message("login ok");
  g_printf("login: %s\npass: %s\n",
	   gtk_entry_get_text(GTK_ENTRY(g_login_entry)),
	   gtk_entry_get_text(GTK_ENTRY(g_password_entry)));
  set_string("login");
  set_string("ok");
  set_string(gtk_entry_get_text(GTK_ENTRY(g_login_entry)));
  set_string(gtk_entry_get_text(GTK_ENTRY(g_password_entry)));
  set_int(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(g_remember_password)));
  flush_io_channel();
  gtk_widget_hide_all(g_login_window);
}

void	on_login_cancel_button_clicked(GtkWidget *widget, gpointer user_data)
{
  (void) widget;
  (void) user_data;

  set_string("login");
  set_string("cancel");
  set_string("");
  set_string("");
  set_int(0);
  flush_io_channel();
  gtk_widget_hide_all(g_login_window);
}

void	on_login_entry_activate(GtkWidget *widget, gpointer user_data)
{
  (void) widget;
  (void) user_data;

  gtk_widget_grab_focus(g_password_entry);
}

int	handle_login()
{
  char* tag = get_string();

  if (!g_glade_login_xml)
    {
      g_glade_login_xml = gui_load_widget("login_window");
      if (!g_glade_login_xml)
	return FALSE;
      g_login_window = glade_xml_get_widget(g_glade_login_xml, "login_window");
      g_login_entry = glade_xml_get_widget(g_glade_login_xml, "login_entry");
      g_password_entry = glade_xml_get_widget(g_glade_login_xml,
					      "password_entry");
      g_remember_password = glade_xml_get_widget(g_glade_login_xml,
						 "remember_password");
      GUI_BRANCH(g_glade_login_xml, on_password_entry_activate);
      GUI_BRANCH(g_glade_login_xml, on_login_entry_activate);
      GUI_BRANCH(g_glade_login_xml, on_login_cancel_button_clicked);
      GUI_BRANCH(g_glade_login_xml, gtk_widget_grab_focus);
      gtk_widget_hide_all(g_login_window);
    }

  if(!strncmp(tag, "hide", 4)) {
    gtk_widget_hide_all(g_login_window);
  } else {
    char* default_name = tag;
    char* default_password = get_string();
    int	remember_password = get_int();

    gtk_entry_set_text(GTK_ENTRY(g_login_entry), default_name);
    gtk_entry_set_text(GTK_ENTRY(g_password_entry), default_password);
    if (strcmp(default_name, "") != 0)
      gtk_widget_grab_focus(g_password_entry);
    if (remember_password)
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(g_remember_password), TRUE);
    g_free(default_password);

    gui_center_window(GTK_WINDOW(g_login_window));
  }

  g_free(tag);

  return TRUE;
}
