/* *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *
 */

#include <gtk/gtk.h>
#include <glade/glade.h>
#include <string.h>
#include <stdio.h>
#include "gui.h"
#include "network.h"

static GtkWidget*	g_future_action_window;
static GladeXML*	g_glade_future_action_xml = 0;
static gboolean		g_future_action_disable = FALSE;
static int 		g_serial = 0;

void	on_future_action_toggled(GtkWidget *widget, gpointer user_data)
{
  (void) user_data;

  if(g_future_action_disable)
    return;

  set_string("future_action");
  set_int(g_serial);
  if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget))) {
    char* name = gtk_widget_get_name(widget);
    int index = 0;
    sscanf(name, "checkbutton%d", &index);
    set_int(index - 1);
  } else {
    set_int(-1);
  }
  flush_io_channel();
}

int	handle_future_action(void)
{
  char*	tag = get_string();
  
  if (!g_glade_future_action_xml)
    {
      g_glade_future_action_xml = gui_load_widget("future_action_window");
      g_future_action_window = glade_xml_get_widget(g_glade_future_action_xml,
						    "future_action_window");
      g_assert(g_future_action_window);
      GUI_BRANCH(g_glade_future_action_xml, on_future_action_toggled);
    }

  g_future_action_disable = TRUE;

  if(!strcmp(tag, "show"))
    {
      GtkWindow* window = GTK_WINDOW(g_future_action_window);
      int	window_width, window_height;
      int	screen_width = gdk_screen_width();
      int	screen_height = gdk_screen_height();

      gtk_widget_show_all(GTK_WIDGET(window));
      gtk_window_get_size(window, &window_width, &window_height);
      gtk_window_move(window,
		      0,
		      screen_height - 300);
    }
  else if(!strcmp(tag, "hide"))
    {
      gtk_widget_hide_all(g_future_action_window); 
    }
  else if(!strcmp(tag, "set"))
    {
      int i;
      g_serial = get_int();
      char* selected = get_string();
      char selected_button[32];
      if(strlen(selected) > 0)
	snprintf(selected_button, 32, "checkbutton%02d", atoi(selected) + 1);
      else
	selected_button[0] = '\0';
							      
      for(i = 1; i <= 8; i++) {
	char tmp[32];
	snprintf(tmp, 32, "checkbutton%02d", i);
	GtkWidget* button = glade_xml_get_widget(g_glade_future_action_xml,
						 tmp);
	char* label = get_string();
	if(strlen(label) > 0) {
	  gtk_widget_show(button);
	} else {
	  gtk_widget_hide(button);
	}
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button), !strcmp(selected_button, tmp));
	gtk_button_set_label(GTK_BUTTON(button), label);
	g_free(label);
      }
      g_free(selected);
    }

  g_future_action_disable = FALSE;
  
  g_free(tag);

  return TRUE;
}
