/* *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *
 */

#include <gtk/gtk.h>
#include <glade/glade.h>
#include <string.h>
#include "gui.h"
#include "network.h"

static GtkWidget*	g_blind_window;
static GtkWidget*	g_blind_message;
static GladeXML*	g_glade_blind_xml = 0;

void	on_blind_no_clicked(GtkWidget *widget, gpointer user_data)
{
  (void) widget;
  (void) user_data;

  g_message("no");
  set_string("blind");
  set_string("post");
  set_string("no");
  flush_io_channel();
}

void	on_blind_yes_clicked(GtkWidget *widget, gpointer user_data)
{
  (void) widget;
  (void) user_data;

  g_message("yes");
  set_string("blind");
  set_string("post");
  set_string("yes");
  flush_io_channel();
}

void	on_wait_blind_clicked(GtkWidget *widget, gpointer user_data)
{
  (void) widget;
  (void) user_data;

  g_message("yes");
  set_string("blind");
  set_string("post");
  set_string("wait");
  flush_io_channel();
}

int	handle_blind(void)
{
  char*	tag = get_string();
  
  if (!g_glade_blind_xml)
    {
      g_glade_blind_xml = gui_load_widget("blind_window");
      g_blind_window = glade_xml_get_widget(g_glade_blind_xml,
					    "blind_window");
      g_assert(g_blind_window);
      g_blind_message = glade_xml_get_widget(g_glade_blind_xml,
					     "post_blind_message");
      g_assert(g_blind_message);
      GUI_BRANCH(g_glade_blind_xml, on_blind_no_clicked);
      GUI_BRANCH(g_glade_blind_xml, on_blind_yes_clicked);
      GUI_BRANCH(g_glade_blind_xml, on_wait_blind_clicked);
    }

  if(!strcmp(tag, "show"))
    {
      GtkWindow* window = GTK_WINDOW(g_blind_window);
      int	window_width, window_height;
      int	screen_width = gdk_screen_width();
      int	screen_height = gdk_screen_height();

      gtk_widget_show_all(GTK_WIDGET(window));
      gtk_window_get_size(window, &window_width, &window_height);
      gtk_window_move(window,
		      (screen_width - window_width) / 2,
		      screen_height - window_height * 2);
    }
  else if(!strcmp(tag, "hide"))
    {
      gtk_widget_hide_all(g_blind_window); 
    }
  else if(!strcmp(tag, "blind message"))
    {
      char*	message = get_string();
      char*	wait_blind = get_string();

      gtk_label_set_text(GTK_LABEL(g_blind_message), message);
      GtkWidget* post_blind_widget = glade_xml_get_widget(g_glade_blind_xml,
							  "post_blind");
      GtkWidget* wait_blind_widget = glade_xml_get_widget(g_glade_blind_xml,
							  "wait_blind");
      g_assert(post_blind_widget);
      g_assert(wait_blind_widget);
      if(strlen(message) > 0)
	{
	  gtk_widget_set_sensitive(post_blind_widget, TRUE);
	}
      else
	{
	  gtk_widget_set_sensitive(post_blind_widget, FALSE);
	}

      if(!strcmp(wait_blind, "yes"))
	{
	  gtk_widget_set_sensitive(wait_blind_widget, TRUE);
	}
      else
	{
	  gtk_widget_set_sensitive(wait_blind_widget, FALSE);
	}
	
      g_free(message);
      g_free(wait_blind);
    }
  
  g_free(tag);

  return TRUE;
}
