/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Henry Precheur	<henry@precheur.org>
 *
 */

#ifndef	ugame_text_h
#define	ugame_text_h

#include <string>
#include <osg/Geode>
#include <osg/Image>
#include <osgText/Text>

#include "ugame/ugameexport.h"

struct UGAME_EXPORT UGAMEBasicText: public osg::Geode
{
  UGAMEBasicText(const std::string& str, osgText::Font* font = 0);
  
  osgText::Text*	getText();
  const osgText::Text*	getText() const;
  
  void	setStringUTF8(const std::string& str); 
  std::string	getStringUTF8() const;
protected:
  osg::ref_ptr<osgText::Text>	mText;
};

struct UGAME_EXPORT UGAMEFramedText: public UGAMEBasicText
{
  UGAMEFramedText(const std::string& str, osg::Image* img, osgText::Font* font = 0);

  void	setStringUTF8(const std::string& str);

  osg::Geometry*	getGeometry();
  const osg::Geometry*	getGeometry() const;

protected:
  osg::ref_ptr<osg::Geometry>	mGeom;
  osg::ref_ptr<osg::Vec3Array>	mVertice;
};

/*
 * FIXME rework this function
 */
void	UGAME_EXPORT UGAMEPlaceTextInHud(osgText::Text* text, enum osgText::Text::AlignmentType align,
			  unsigned screen_width, unsigned screen_height);

#endif // ugame_text_h
