/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *  Vincent Caron <zerodeux@gnu.org>
 *
 */

#ifndef maf_window_h 
#define maf_window_h

#ifndef MAF_USE_VS_PCH
#include <string>
#include <list>
#include <glib.h>
#include <SDL.h>
#include <SDL_video.h>
#include <maf/mafexport.h>
#include <osg/Node>
#endif

#include <maf/view.h>


//! Window
/*!
*/
class MAF_EXPORT MAFWindow
{
public:
  GError* pError;

  /** @name Window life cycle */
  //@{
  MAFWindow();
  virtual ~MAFWindow();
  bool Init(void);
  //@}

  /** @name Settings */
  //@{
  int  GetWidth(void) { return mWidth; }
  void SetWidth(int width) { mWidth = width; }
  int  GetHeight(void) { return mHeight; }
  void SetHeight(int height) { mHeight = height; }
  bool GetOpenGL(void) { return mOpenGL; }
  void SetOpenGL(bool opengl) { mOpenGL = opengl; }
  SDL_Surface* GetSurface(void) { return mSurface; }
  bool GetFullScreen(void) { return mFullScreen; }
  void SetFullScreen(bool fullScreen) { mFullScreen = fullScreen; }

  void SwapBuffers();
  void SetCaption(const std::string& Caption);
  //@}

  /** @name Event loop */
  //@{
  bool AddView(MAFView* pView);
  bool DelView(MAFView* pView);
  void Render();
  //@}

  // help me refactor cursor code please !!!
  // gl cursor  is accessed set from scene.cpp with data here ???
  bool mWarpMouseOccur;
  int mWarpX,mWarpY;

private:
  typedef std::list<MAFView*> ViewList;

  bool mFullScreen;
  int mWidth;
  int mHeight;
  ViewList mViews;
  SDL_Surface* mSurface;
  bool mOpenGL;


};

 
#endif // maf_window_h
