/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Cedric Pinson <cpinson@freesheep.org>
 *  Igor Kravtchenko <igor@obraz.net>
 *
 */

#ifndef _maf_utils_h
#define _maf_utils_h

#ifndef MAF_USE_VS_PCH
#include <maf/mafexport.h>
#include <osg/Matrix>
#include <osg/Geode>
#endif

MAF_EXPORT osg::Matrix MAFComputeLocalToWorld(osg::Node* src, int parentValidMask = 0);
MAF_EXPORT osg::Node* GetNode(osg::Node* node, const std::string& name);
MAF_EXPORT osg::Geode* GetGeode(osg::Node* node);

MAF_EXPORT void getNameAndPath(const std::string &filename, std::string &name, std::string &path);

#endif // _maf_utils_h
