/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *
 */

#ifndef maf_network_h 
#define maf_network_h

#ifndef MAF_USE_VS_PCH
#include <map>
#include <vector>
#include <string>
#include <glib.h>

#include <osg/Referenced>
#include <maf/mafexport.h>
#endif

typedef struct _object PyObject; // forward declaration

#define MAF_PACKET_NONE		0

class MAFPacket;

class MAF_EXPORT MAFPacketsModule {
public:
  MAFPacketsModule(const std::string& module);
  ~MAFPacketsModule();

  MAFPacket* Create(const std::string& pyclass);

  long GetType(const std::string& name) const;

private:
  void LoadTypes( void );

  std::map<std::string,long> mTypes;
  PyObject* mModule;
};

class MAF_EXPORT MAFPacket : public osg::Referenced
{
public:
  MAFPacket(MAFPacketsModule* module, PyObject* object);
protected:
  virtual ~MAFPacket();
public:

  void SetMember(const std::string& name, const std::string& value);
  void SetMember(const std::string& name, long value);
  void SetMember(const std::string& name, bool value) { SetMember(name, (long)value); }
  void SetMember(const std::string& name, int value) { SetMember(name, (long)value); }
  void SetMember(const std::string& name, guint value) { SetMember(name, (long)value); }
  void SetMember(const std::string& name, double value);
  void SetMember(const std::string& name, float value) { SetMember(name, (double)value); }
  void SetMember(const std::string& name, const std::vector<int>& values);

  void GetMember(const std::string& name, std::string& value) const;
  void GetMember(const std::string& name, long& value) const;
  void GetMember(const std::string& name, bool& value) const { long tmp; GetMember(name, tmp); value = tmp != 0; }
  void GetMember(const std::string& name, int& value) const { long tmp; GetMember(name, tmp); value = (int)tmp; }
  void GetMember(const std::string& name, guint& value) const { long tmp; GetMember(name, tmp); value = (guint)tmp; }
  void GetMember(const std::string& name, double& value) const;
  void GetMember(const std::string& name, float& value) const { double tmp; GetMember(name, tmp); value = (float)tmp; }
  void GetMember(const std::string& name, std::vector<int>& values) const;

  bool IsType(const std::string& name) const;
  long GetType(void) const { return mType; }
  PyObject* GetPacket() { return mPacket; }

private:
  void SetMember(const std::string& name, PyObject* value);
  void GetMember(const std::string& name, PyObject*& value) const;
  
  long mType;
  MAFPacketsModule* mPacketsModule;
  PyObject* mPacket;
};

#endif // maf_network_h
