/**
    Copyright (C) 2004 Cedric Pinson <cpinson@freesheep.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 ****************************************************************************
 * @file   exg_visitor_generate_normal.h
 *
 * @brief   base for material exchange
 *
 *****************************************************************************
 *
 * @author  Cedric Pinson
 *
 * @date    Created 2004/04
 *
 * @version $Id: exg_visitor_generate_normal.h,v 1.3 2004/04/06 17:39:54 loic Exp $
 *
 ****************************************************************************/


#ifndef exg_nodevisitor_generate_normal_h
#define exg_nodevisitor_generate_normal_h

#include <exg/exg_vector3.h>
#include <exg/exg_visitor.h>
#include <cassert>

namespace exg
{

  /**
   *  Visitor that generate normal for all vertexes that are referenced
   *  by polygons from material. When processed material have a field "normal"
   *  and all vertex have a field "normal" associated with a VectorFloat(3)
   *  note use need to process a VisitorBuildEdgeConnectivity
   */
  class VisitorBuildEdgeConnectivity;
  class ConnectivityPolygon;
  class ConnectivityPoint;
  class ConnectivityEdge;
  class EXG_EXPORT VisitorGenerateNormalToMaterial : public Visitor
  {

    float mAngle;
    VisitorBuildEdgeConnectivity* mConnectivity;

   public:

    VisitorGenerateNormalToMaterial(VisitorBuildEdgeConnectivity* node,
                                    float limiteAngleBetweenFace=90):
      Visitor(ONCE),mAngle(limiteAngleBetweenFace),mConnectivity(node) { assert(node); }

    Vector3f ComputeNormalPoint(ConnectivityPolygon* current,ConnectivityPoint* point);
    Vector3f ComputeNormalEdge(ConnectivityPolygon* current,ConnectivityEdge* edge);
    bool IsAngleLessThanSmoothingAngle(ConnectivityPolygon* current,ConnectivityPolygon* poly) { return true;}

    void Apply(Object& node) {}
    void Apply(Material& node);
    void Apply(Polygon& node);
    void Apply(Vertex& node) {}
    void Apply(Point& node) {}
    void Apply(Mesh& node) { Traverse((Object&)node); }
    void Apply(File& node) {}

  };

}

#endif 
