/**
   Copyright (C) 2004 Cedric Pinson <cpinson@freesheep.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   ****************************************************************************
   * @file   exg_utlis.h
   *
   * @brief   some base functions to help users
   *
   *****************************************************************************
   *
   * @author  Cedric Pinson
   *
   * @date    Created 2004/04
   *
   * @version $Id: exg_utils.h,v 1.5 2004/05/25 16:04:22 cpinson Exp $
   *
   ****************************************************************************/

#ifndef exg_utils_h
#define exg_utils_h

#include <exg/exg_material.h>

namespace exg
{

  /** 
   *  material helpers
   *  construct a map element for the maps field
   *
   *  "maps"  VectorObjectPointer() contains pointer of MapObjectPointer() used
   *          to describe a channel that have a consequence on vertex data. 
   *          Typically when using texture mapping, vertexes have additionnal
   *          data like uv. So entries in "maps" give the description of this.
   *      "name"     File() identify a channel by a name. This channel name must be
   *                 used to find the good channel in vertexes @see Vertex.
   *      "file"     PointerObject() identify a pointer of File() in Mesh["files"]
   *                 @see Mesh.
   *      "element"  VectorFloat(1) contains the number of coordinates in vertexes
   *                 @see Vertex. this number is casted to int.
   *      "mode"     File() contains a string we use it like a additive to make a 
   *                 map in additive mode. this field can be omitted.
   *
   */
  inline MapObjectPointer* CreateMaterialMapElement(const std::string name="",File* file=0,int nbElement=1,const std::string& _mode="") {
    MapObjectPointer* m=new MapObjectPointer;
	File* n=new File;
	n->SetName(name);
    (*m)["name"]=n;
    (*m)["file"]=file;
    VectorFloat* f=new VectorFloat();
    (*f).push_back(nbElement);
    (*m)["element"]=f;

    if (!_mode.empty()) {
      File* md=new File;
	    md->SetName(_mode);
      (*m)["mode"]=md;
    }
    return m;
  }


  /** 
   *  material helpers
   *  construct a empty maps to assign to a meterial
   *
   *  "maps"  VectorObjectPointer() contains pointer of MapObjectPointer() used
   *          to describe a channel that have a consequence on vertex data. 
   *          Typically when using texture mapping, vertexes have additionnal
   *          data like uv. So entries in "maps" give the description of this.
   */
  inline VectorObjectPointer* CreateMaterialMaps() {
    return new VectorObjectPointer;
  }



}
#endif