import os,sys
from ConfigParser import ConfigParser
import xmlcolor as xc
import traceback as tb
class Config:
    
    _types={}
    
    def __init__(self, files=[]):
        self._files=files
    
    def set_type(self, k, t):
        """ set the type of  a variable """
        self._types[k]=t
    
    def load(self, file=None):
        if file is not None:
            self._files.insert(0, file)
        for f in self._files:
            if os.path.exists(f):
                cp=ConfigParser()
                cp.read(f)
                for k,v in cp.items('Global'):
                    setattr(self, k, self._types.get(k,str)(v))
                break


#set default output stream
_debug_file=sys.stderr

def set_debug_file(file):
    global _debug_file
    _debug_file=file

def debug(s, xml=0, colorize=1):
    frame=tb.extract_stack()[-2]
    dummy,file=os.path.split(frame[0])
    print >> _debug_file, "%s, line %d at %s:"%(file, frame[1], frame[2])
    if xml and  colorize:
        print >> _debug_file, xc.color(s)
    else:
        print >> _debug_file, s
    print >> _debug_file, "-"*80

   
