from xmlutils import *
from elements import Iq

#Namespaces URIs
ns_iq_auth='jabber:iq:auth'

# TODO: implement plain authentication also
class LegacyLoginManager:
    """ Handling legacy non-SASL authentication """

    def __init__(self, stream, username, secret, resource):
        """ stream: XMLStream protocol instance """
        self._stream=stream
        self._username=username
        self._password=secret
        self._resource=resource
   
    def start(self):
        """ start the registration process """
        #self._d_finished=defer.Deferred()
        self.sendAuthRequest()
        #return self._d_finished
    
    def sendAuthRequest(self):
        """ send an authentication request """
        iq=Iq(ttype='get', to=self._stream.transport.getPeer()[1])
        q=iq.setQueryNS(ns_iq_auth)
        c=ezel('username')
        c.text(self._username)
        q.appendChild(c.dom())
        d=self._stream.sendIq(iq)
        d.addCallback(self.gotAuthFields)
        d.addErrback(self.gotAuthFieldsError)
    
    def gotAuthFields(self, iq):
        """ received the answer of an authentication request """
        q=iq.getQueryNode()
        fields=[c.localName for c in q.childNodes]
        if 'digest' in fields:
            self.sendAuthDigest()

    def gotAuthFieldsError(self, fail):
        """ authentication fields error """
        if fail.type=='iq':
            fail='Auth fields error'
        self._d_finished.errback(fail)   
            
    def sendAuthDigest(self):
        """ prepare and send the authentication digest """
        iq=Iq(to=self._stream.transport.getPeer()[1], ttype='set')
        query=iq.setQueryNS(ns_iq_auth)
        #compute the digest
        import sha
        digest=sha.new(self._stream.getId()+self._password).hexdigest()
        c1=ezel('username')
        c1.text(self._username)
        query.appendChild(c1.dom())
        c1=ezel('digest')
        c1.text(digest)
        query.appendChild(c1.dom())
        c1=ezel('resource')
        c1.text(self._resource)
        query.appendChild(c1.dom())
        #send the iq auth
        d=self._stream.sendIq(iq)
        d.addCallback(self.gotAuthResult)
        d.addErrback(self.gotAuthResultError)
        
    def gotAuthResult(self, iq):
        """ got the auth result """
        self._stream.authSuccess()
        #self._d_finished.callback('')
    
    def gotAuthResultError(self, fail):
        """ got an auth result error """
        if fail.type=='iq':
            iq=fail.value
            e=iq.getChild('error')
            #(code, reason)
            fail=failure.Failure((e.getAttribute('code'), get_text(e)), 'code')
        #else:
        #    fail.printDetailedTraceback()
        #self._d_finished.errback(fail)
        self._stream.authFailed(fail)
