"""
XMPP Client library
(c) 2004 Fabio Forno
"""

import xmppstream as xmpp
from xmppstream import XMPPBaseFactory
from client import XMPPBaseClient, XMPPClientFactory
from roster import RosterMixIn
from xmlutils import * 
from elements import Iq
import utils
import sys
from twisted.internet import reactor, protocol
from disco import DiscoMixIn

#utility functions
encoding='ISO-8859-15'
ns_component='http://jabberd.jabberstudio.org/ns/component/1.0'

# Add Disco MixIn
class XMPPBaseComponent(XMPPBaseClient):
    
    def __init__(self):
        XMPPBaseClient.__init__(self)
        self.setHandler('', 'bind', self.gotBind)
        self.setHandler('', 'route', self.gotRoute)

    def openStream(self):
        """ Open the stream """
        f=self.factory
        ch=self.transport
        
        if float(f.version)>=1.0:
            version="version='%s'"%(f.version)
        else:
            version=''
            
        s="""<?xml version='1.0' encoding='UTF-8'?>
<stream:stream to='%s' xmlns:stream='%s' %s>"""%(ch.getPeer()[1], xmpp.ns_xmlstream, version)
        
        if f.debug:
            utils.debug(s, xml=1)
            
        self.writeData(s)
        
    def authSuccess(self):
        """ """
        self.doBind(self.factory.bind)
    
    # -------------------------------------------
    # bind related functions
    def doBind(self, name):
        """ """
        bind=ezel('bind', name=name, xmlns=ns_component)
        self.sendPacket(bind.dom())
        
    def gotBind(self, tag):
        """ """
        error=tag.getAttribute('error')
        if error:
            self.bindFailed(error)
        else:
            self.bindSuccess()
            
    def bindSuccess(self):
        """ override this to start work once authenticated """
        pass # now we can start work

    def bindFailed(self, fail=None):
        utils.debug(fail)

    # -------------------------------------------
    # Route
    def gotRoute(self, tag):
        """ dispatching messages got through route """
        
        if tag.hasAttribute('error'):
            self.gotRouteError(tag)
            return
        
        for c in tag.childNodes:
            # use the same mechanism for elementReceived in order to dispatch
            # messages
            #import pdb; pdb.set_trace()
            if c.namespaceURI == 'jabber:client': ns=''
            else: ns=tag.namespaceURI
            try: h=self._handlers[ns][c.localName]
            except KeyError: self.gotUnknownElement(c)
            else: h(c)             
    
    def gotRouteError(self, tag):
        pass
    
    def sendStanza(self, packet, ns='jabber:client'):
        """ use route to send XML stanzas """
        # XXX should presence be inserted into <route/> packets ?
        if packet.getName()!='presence':
            route=ezel('route', xmlns=ns_component)
            to=str(packet.getTo())
            if to: route['to']=to
            route['from']=self.factory.bind
            packet.setFrom(self.factory.bind)
            p=packet.getDOM()
            p.setAttribute('xmlns', ns)
            route.dom().appendChild(p)
            self.sendPacket(route.dom())
        else:
            self.sendPacket(packet.dom())
        
class XMPPComponent(XMPPBaseComponent, RosterMixIn, DiscoMixIn):
    """ XMPP Component with Roster """
    
    def __init__(self):
        XMPPBaseComponent.__init__(self)
        RosterMixIn.__init__(self)
        DiscoMixIn.__init__(self)
        
    def bindSuccess(self):
        """ Called when the client has authenticated """
        XMPPBaseComponent.bindSuccess(self)
        self.getRoster()
       
class XMPPComponentFactory(XMPPBaseFactory, protocol.ReconnectingClientFactory):
    
    protocol=XMPPComponent
    
    xmlns=ns_component #'' #jabber:client'
    version='1.0'
    debug=1

    def __init__(self, server, username, password, bind, realm=None, tls='never'):
        """  tls: never, ifvail, mandatory
        """
        XMPPBaseFactory.__init__(self)
        
        self.username=username
        self.password=password
        self.server=server
        self.realm=realm or 'jabberd-router'
        self.use_tls=tls
        self.bind=bind+"."+self.server
        self.authzid=None
        self.auth='sasl'

    def buildProtocol(self, addr):
        p=protocol.ReconnectingClientFactory.buildProtocol(self, addr)
        self._bindListeners(p)
        return p
        
def _test():
    from utils import Config
    c=Config(['component2.cfg'])
    c.username='test'
    c.bind='test'
    c.password='test'
    c.server='jabber.example.org'
    
    if len(sys.argv)>1: c.load(sys.argv[1])
    else: c.load()
    
    f=XMPPComponentFactory(c.server, c.username, c.password, c.bind)
    
    reactor.connectTCP(c.server, 5347, f)
    reactor.run()
    
if __name__=='__main__':
    _test()
