#ifndef vs_PerlinNoise_H
#define vs_PerlinNoise_H

/*
 *
 * videoSpace/image/processing/noise/PerlinNoise.H --
 *
 * Copyright (C) Nicolas Roussel
 *
 * See the file LICENSE for information on usage and redistribution of
 * this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */


class PerlinNoise1D {
private:
  int *p ;
  float *g1 ;
public:
  PerlinNoise1D(void) ;
  ~PerlinNoise1D() ;
  float noise(float arg) ;
} ;

class PerlinNoise2D {
private:
  int *p ;
  typedef float pt2D[2] ;
  pt2D *g2 ;
public:
  PerlinNoise2D(void) ;
  ~PerlinNoise2D() ;
  float noise(float x, float y) ;
} ;

class PerlinNoise3D {
private:
  int *p ;
  typedef float pt3D[3] ;
  pt3D *g3 ;
public:
  PerlinNoise3D(void) ;
  ~PerlinNoise3D() ;
  float noise(float x, float y, float z) ;
} ;

#endif
