/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *
 */

#include "pokerStdAfx.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */
#ifdef WIN32
#include "config_win32.h"
#include <cstdio>
# define snprintf _snprintf
#endif

#include <osgDB/ReadFile>
#include <osg/GLExtensions>
#include <osg/Geometry>
#include <osg/PositionAttitudeTransform>
#include <osgText/Text>

#include <maf/application.h>
#include <maf/split.h>
#include <maf/window.h>

#include <PokerSplashScreen.h>
#include <PokerError.h>


PokerSplashScreenModel::PokerSplashScreenModel(MAFApplication* application) {
  float width = application->GetWindow(true)->GetWidth();
  float height = application->GetWindow(true)->GetHeight();

  osg::ref_ptr<osg::Texture2D> texture = new osg::Texture2D;
  osg::Image* image;
  {
    const osg::Texture::Extensions* extensions = texture->getExtensions(0,true);
    const std::string &datadir = application->HeaderGet("settings", "/settings/data/@path"); 
    std::string logopath = datadir + "/" + application->HeaderGet("sequence", "/sequence/splash/@image");
    int size = extensions->maxTextureSize();
    if(size > 512) size = 1024;
    char tmp[256];
    snprintf(tmp, 256, logopath.c_str(), size, size);
    image = osgDB::readImageFile(tmp);
  }
  if(image) {
    texture->setImage(image);

    osg::StateSet* dstate = new osg::StateSet;
    dstate->setMode(GL_CULL_FACE,osg::StateAttribute::OFF);
    dstate->setMode(GL_LIGHTING,osg::StateAttribute::OFF);
    dstate->setTextureAttributeAndModes(0, texture.get(), osg::StateAttribute::ON);

    osg::Geometry* geom = new osg::Geometry;
    geom->setStateSet(dstate);

    osg::Vec2Array* tcoords = new osg::Vec2Array(4);
    (*tcoords)[0].set(0.0f,0.25f);
    (*tcoords)[1].set(0.0f,1.0f);
    (*tcoords)[2].set(1.0f,1.0f);
    (*tcoords)[3].set(1.0f,0.25f);
    geom->setTexCoordArray(0,tcoords);

    osg::Vec3Array* coords = new osg::Vec3Array(4);
    (*coords)[0].set(0.f, 0.f, 0.f);
    (*coords)[1].set(0.f, height, 0.f);
    (*coords)[2].set(width, height, 0.f);
    (*coords)[3].set(width, 0.f, 0.f);
    geom->setVertexArray(coords);

    osg::Vec4Array* colours = new osg::Vec4Array(1);
    (*colours)[0].set(1.0f,1.0f,1.0,1.0f);
    geom->setColorArray(colours);
    geom->setColorBinding(osg::Geometry::BIND_OVERALL);

    geom->addPrimitiveSet(new osg::DrawArrays(osg::PrimitiveSet::QUADS,0,4));

    // set up the geode.
    osg::Geode* geode = new osg::Geode;
    geode->setName("SplashScreen");
    geode->addDrawable(geom);

    SetNode(geode);
  }
}

PokerSplashScreenModel::~PokerSplashScreenModel() {
}

PokerSplashScreenController::PokerSplashScreenController(MAFApplication* application) {
  SetModel(new PokerSplashScreenModel(application));
}

PokerSplashScreenController::~PokerSplashScreenController() {
}

bool PokerSplashScreenController::Update(MAFApplication* application) {
  return true;
}
