/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Johan Euphrosine <johan@mekensleep.com>
 *
 */

#ifndef __pokerseat_h__
#define __pokerseat_h__

#include <osg/Vec3>

#include <maf/controller.h>
#include <maf/interpolator.h>
#include <ugame/artefact.h>

#include "PokerApplication.h"

namespace osg { class PositionAttitudeTransform; }

class PokerApplication;

class PokerSeatModel : public UGAMEArtefactModel
{
 public:
  PokerSeatModel();
  ~PokerSeatModel();
  void Init();
  int mId;
  bool mFree;

  osg::ref_ptr<osg::PositionAttitudeTransform> mArrowPAT;

  MAFLinearInterpolator<osg::Vec3> mScaleInterpolator;
  MAFInterpolatorTimer<> mTimer;
  osg::ref_ptr<osg::Geode> mSeatGeode;
  float mMinAlpha;
  float mAngleAlpha;
};

class PokerSeatController : public UGAMEArtefactController
{
 public:
  PokerSeatController();
  ~PokerSeatController();
  void Init(int id, PokerApplication *game);
  void Enable();
  void Disable();
  bool Update(MAFApplication *game);
  PokerSeatModel *GetModel() { return static_cast<PokerSeatModel *>(UGAMEArtefactController::GetModel()); }
};

class PokerSeatManager  : public MAFController
{
 public:
  PokerSeatManager();
  ~PokerSeatManager();
  void Init(PokerApplication *game);
  void SetSeats(const std::vector<int> &currentTableSeats);
  void DisableAllSeats();
  bool Update(MAFApplication *game);
  unsigned int GetSeatsCount(void) { return mSeats.size(); }
  void MainPlayerArrive(const std::vector<guint> &seats);
  void MainPlayerLeave(const std::vector<guint> &seats);
  void MainPlayerSeated(unsigned int seat);
  void PlayerSeated(unsigned int seat);
  void PlayerLeave(unsigned int seat);
 private:
  bool mMainPlayerIn;
  unsigned int  mSeatsCount;
  std::vector<bool> mCurrentTableSeats;
  std::vector< osg::ref_ptr<PokerSeatController> > mSeats;
  PokerApplication* mGame;
};

#endif // __pokerseat_h__
