/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *  Igor Kravtchenko <igor@obraz.net>
 *
 */

#ifndef _pokerplayercamera_h
#define _pokerplayercamera_h

#include <map>
#include <string>

#include <PokerCamera.h>

#include <maf/clock.h>
#include <ugame/text.h>

class PokerCameraController;

class PokerPlayerCamera {
 public:
  PokerPlayerCamera(PokerCameraController* camera, std::map<std::string,std::string>& params);
  ~PokerPlayerCamera() {}
  
  enum UpdateResult {
    NONE = 0,
    START_LOOK_CARDS = 1,
    END_LOOK_CARDS = 2
  };
  UpdateResult Update(SDL_Event* event, float delta, bool focused);

  void SetCameraModel(const std::string& name, const MAFCameraModel& model) { mCameras[name] = model; }
  void SetPlayerPosition(const osg::Vec3& position) { mPositionOfPlayerInWorldspace = position; }
  void SetPlayerDirection(const osg::Vec3& direction) { mDirectionOfPlayerInWorldspace = direction; }
  void SetLookingCardAnimationTimeout(double timeout) { mLookingCardAnimationTimeout = timeout; }
  void SetInteractorSelected(bool selected) { mInteractorSelected = selected; }
  PokerCameraController *GetCameraController() { return mCamera.get(); }
 private:
  std::map<std::string,MAFCameraModel> mCameras;
  bool mInteractorSelected;

  double mTimePlaying;
  double mTimeWaiting;
  double mTimeNoise;
  double mInternalTime; // time since the player is here

  double mCameraTimeout;
  double mCameraTotalTimeout;

  int mCameraElapsed;
  float mCameraTimeToReach;
  float mCameraTimeToRewind;
  float mCameraTimeToRelease;
  float mCameraFactorToReach;
  float mCameraFactorToRewind;
  float mCameraTimeShoulder;

  float mCameraTimeToReachLook;
  float mCameraTimeToRewindLook;

  osg::Vec3 mDirectionOfPlayerInWorldspace;
  osg::Vec3 mPositionOfPlayerInWorldspace;

  osg::ref_ptr<PokerCameraController> mCamera;
  void MoveCameraToCamLookModel();
  void MoveCameraToPreviousModel();
  void MoveCamera(const osg::Vec3 &position, const osg::Vec3 &target);
  bool CameraEvaluateModeTransition();
  void BeginFreeMode();
  void ExecuteFreeMode();
  void EndFreeMode();
  void BeginEnterMode();
  void ExecuteEnterMode();
  void EndEnterMode();
  void BeginGameMode();
  void ExecuteGameMode();
  void EndGameMode();
  void BeginDirectMode();
  void ExecuteDirectMode();
  void EndDirectMode();
  void BeginLeaveMode();
  void ExecuteLeaveMode();
  void EndLeaveMode();

  double mCameraLookCardTimeout;
  int mCameraLookCardState;
  double mCameraMinTimeToLookCards;
  double mCameraVelocityToLookCards;
  double mLookingCardAnimationTimeout;

  float mCameraButtonDelayToActivateDirectMode;
  float mCameraGameModeDelay;
  float mCameraGameModeMouseThreshold;
  float mCameraGameModeDelayLookCards;

  double mDeltaS;
  float mMouseDelta[2];
  float mMouseDeltaOverall[2];
  float mMouseDeltaRel[2];
  bool mCameraMouseMotion;
  bool mDisplayedAndFocused;
  bool mCameraButtonPressed;
  bool mCameraButtonClickUp;
  bool mCameraButtonClickDown;
  bool mCameraButtonClickFocused;
  double mCameraButtonPressedDuration;
  std::vector<osg::Vec2> mCameraKeys;

  osg::Vec3Array *array_;
  osg::Vec2f hudPos_[9];
  float factor_[9];
  int sens_;
  float timeSinceFirstPersonView_;

  osg::MatrixTransform *mt_[9];

  UGAMEBasicText *textName_[9];
  UGAMEBasicText *textLastAction_[9];

  void updatePos(float dt);
};

#endif // _pokerplayercamera_h
