/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Cedric Pinson <cpinson@freesheep.org>
 *
 */

#include "pokerStdAfx.h"

#include "PokerMoveChips.h"
#include "PokerApplication.h"
#include "PokerPot.h"
#include "PokerError.h"
#include <osg/Geode>
#include <osg/ShapeDrawable>


PokerMoveChipsBase::PokerMoveChipsBase(PokerApplication* game)
{
  mChips=new PokerChipsStackController(game);
  mFinished=true;
  mTransform=new osg::MatrixTransform;
  mTransform->setMatrix(osg::Matrix::identity());
}

void PokerMoveChipsBase::UpdateTarget() 
{
  std::vector<int> nul(0);

  if (mTargetChips.get()) {
    mTargetChips->AddChips(mChips->GetChips());
    mTargetChips=0;
  }
  mChips->SetChips(nul);
}

void PokerMoveChipsBase::Display(bool state)
{
  if (state)
    mTransform->setNodeMask(0xffffffff);
  else
    mTransform->setNodeMask(0);

}

bool PokerMoveChipsBase::IsFinished()
{
  return mFinished;
}

PokerMoveChipsBase::~PokerMoveChipsBase()
{
  mTransform=0;
  mTargetChips=0;
  mChips=0;
}




PokerMoveChipsBet2PotController::PokerMoveChipsBet2PotController(PokerApplication* game,osg::Node* source):PokerMoveChipsBase(game)
{
  mNode=source;
  mTransform->addChild(mChips->GetModel()->GetArtefact());
  PokerMoveChipsBase::Display(false);
}


PokerMoveChipsBet2PotController::~PokerMoveChipsBet2PotController()
{
  RecursiveClearUserData(mTransform.get());
  mTransform->removeChild(mChips->GetModel()->GetArtefact());
  osg::NodeVisitor* leakNodes = RecursiveLeakCollect(mTransform.get());
  RecursiveLeakCheck(leakNodes);
  mNode=0;
}

void PokerMoveChipsBet2PotController::StartAnimation()
{
  mFinished=false;
  PokerMoveChipsBase::Display(true);
}


void PokerMoveChipsBet2PotController::InitAnimation()
{
  const float mTimeDurationScale = 1.0/osg::PI;
  const float mParamAngleInterpolation=15.0*osg::PI/180.0;

  float timeOfEndPart=0.5;

  mInternalTimer=0;
  timeOfEndPart-=mParamAngleInterpolation*mTimeDurationScale;
  mTimeDuration =fabs( mTimeDurationScale*mAngleToInterpolate); // mAngleToInterpolate*1.0; //
  if (mTimeDuration<timeOfEndPart)
    mTimeDuration=timeOfEndPart;

  mTimeToOffset=mTimeDuration-timeOfEndPart;
}


bool PokerMoveChipsBet2PotController::Update(MAFApplication* application)
{
  PokerApplication* game = dynamic_cast<PokerApplication*>(application);
  if(game->HasEvent())
    return true;

  if (mFinished)
    return true;

  float delta=GetDeltaFrame()*1.0/1000.0;
  osg::Vec3 out;

  mInternalTimer+=delta;

  float timeRatio=mInternalTimer/mTimeDuration;
  float res=mAngleToInterpolate*timeRatio;
  float offset=0;

  if (mInternalTimer>mTimeToOffset) {
    offset=-mDistanceToInterpolate*(mInternalTimer-mTimeToOffset)/(mTimeDuration-mTimeToOffset);
  }


  osg::Matrix rot;
  rot.makeIdentity();
  rot.makeRotate(res,osg::Vec3(0,1,0));
  osg::Vec3 dir=osg::Vec3(0,1,mDistanceFromCenter+offset);
  osg::Matrix tran=osg::Matrix::translate(dir);
  out=(tran*rot*mBaseMatrix).getTrans();

  if (mInternalTimer>mTimeDuration) {
    mFinished=true;
    PokerMoveChipsBase::Display(false);
    UpdateTarget();
  }

  mTransform->setMatrix(osg::Matrix::translate(out));
  return true;
}


void PokerMoveChipsPot2PlayerController::InitAnimation()
{
  const float mTimeDurationScale = 1.0/osg::PI;
  const float mParamAngleInterpolation=15.0*osg::PI/180.0;
  float timeOfEndPart=0.5;

  mInternalTimer=0;
  timeOfEndPart-=mParamAngleInterpolation*mTimeDurationScale;
  mTimeDuration =fabs( mTimeDurationScale*mAngleToInterpolate); // mAngleToInterpolate*1.0; //
  if (mTimeDuration<timeOfEndPart)
    mTimeDuration=timeOfEndPart;

  mTimeToOffset=timeOfEndPart;
}

bool PokerMoveChipsPot2PlayerController::Update(MAFApplication* application)
{
  PokerApplication* game = dynamic_cast<PokerApplication*>(application);
  if(game->HasEvent())
    return true;

  if (mFinished)
    return true;

  float delta=GetDeltaFrame()*1.0/1000.0;
  osg::Vec3 out;

  mInternalTimer+=delta;

  float timeRatio=mInternalTimer/mTimeDuration;
  float res=mAngleToInterpolate*timeRatio;
  float offset=0;

  if (mInternalTimer<mTimeToOffset) {
    offset=-mDistanceToInterpolate*(mTimeToOffset-mInternalTimer)/(mTimeToOffset);
  }

  osg::Matrix rot;
  rot.makeIdentity();
  rot.makeRotate(res,osg::Vec3(0,1,0));
  osg::Vec3 dir=osg::Vec3(0,1,mDistanceFromCenter+offset);
  osg::Matrix tran=osg::Matrix::translate(dir);
  out=(tran*rot*mBaseMatrix).getTrans();

  if (mInternalTimer>mTimeDuration) {
    mFinished=true;
    PokerMoveChipsBase::Display(false);
    UpdateTarget();
  }

  mTransform->setMatrix(osg::Matrix::translate(out));
  return true;
}



PokerMoveChipsPot2PlayerController::~PokerMoveChipsPot2PlayerController()
{
}
