/* -*- c++ -*-
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 * Johan Euphrosine	<johan@mekensleep.com>
 *
 */

#ifndef _POKER_LABEL_H
#define _POKER_LABEL_H

#include <osgText/Text>
#include <osg/PositionAttitudeTransform>
#include <osg/ShapeDrawable>

#include <maf/data.h>
#include <ugame/artefact.h>

class MAFPacket;
class MAFApplication;
class PokerApplication;

struct PokerLabelView : MAFView
{
  PokerLabelView();
  ~PokerLabelView();
  void Init(unsigned int characterSize = 5, const osg::Vec4& fgColor = osg::Vec4(1.0f, 1.0f, 1.0f, 1.0f), const osg::Vec4 &bgColor = osg::Vec4(0.0f, 0.0f, 0.0f, 0.0f));
  void syncLayout();
  void SetText(const std::string &text);
  void SetCenter(const osg::Vec3 &pos);
  void SetPosition(const osg::Vec3 &pos);
  void SetForegroundColor(const osg::Vec4 &fgColor);
  void SetBackgroundColor(const osg::Vec4 &bgColor);
  void SetCharacterSize(unsigned int characterSize);
  static void DisableLightingAndBlending(osg::Geode *geode);
  osg::Node *GetNode();

  osg::ref_ptr<osg::PositionAttitudeTransform> mPAT;

  osg::ref_ptr<osgText::Text> mText;
  osg::ref_ptr<osg::Geode> mTextGeode;

  osg::ref_ptr<osg::Box> mBackgroundBox;
  osg::ref_ptr<osg::ShapeDrawable> mBackgroundDrawable;
  osg::ref_ptr<osg::Geode> mBackgroundGeode;

  osg::Vec3 mPosition;
  osg::Vec4 mBackgroundColor;
  osg::Vec4 mForegroundColor;
};

struct PokerLabelController : public UGAMEArtefactController
{
  PokerLabelController();
  ~PokerLabelController();
  PokerLabelView *GetView() {return static_cast<PokerLabelView *>(UGAMEArtefactController::GetView());}
  void HandleHit(MAFHit& hit);
  void Init();
  void Init(PokerApplication *game, MAFOSGData *data, const std::string &path);
  bool Update(MAFApplication *application);
  void AnchorByName(MAFOSGData *data, const std::string &name);
  void OnEnter();
  void OnFocus();
  void OnLeave();
  void OnClick();
  bool mFocused;
};

#endif
