/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 * Johan Euphrosine	<johan@mekensleep.com>
 *
 */

#include "pokerStdAfx.h"

#include "PokerLabel.h"

#include <string>

#include <osg/Geode>
#include <osg/ShapeDrawable>
#include <osg/Material>
#include <osgText/Text>

#include <maf/controller.h>

#include "PokerApplication.h"

PokerLabelView::PokerLabelView() : mPAT(0), mText(0), mTextGeode(0), mBackgroundBox(0), mBackgroundDrawable(0), mBackgroundGeode(0)
{
}

PokerLabelView::~PokerLabelView()
{
}

void PokerLabelView::Init(unsigned int characterSize, const osg::Vec4& fgColor, const osg::Vec4 &bgColor)
{
  MAFView::Init();
  mPAT = new osg::PositionAttitudeTransform();
  mText = new osgText::Text();
  mTextGeode = new osg::Geode();
  mBackgroundBox = new osg::Box();
  mBackgroundDrawable = new osg::ShapeDrawable(mBackgroundBox.get());
  mBackgroundGeode = new osg::Geode();

  mTextGeode->addDrawable(mText.get()); 
  mBackgroundGeode->addDrawable(mBackgroundDrawable.get());
  
  mTextGeode->setName("PokerLabelView::mTextGeode");
  mBackgroundGeode->setName("PokerLabelView::mBackgroundGeode");

  mPAT->addChild(mTextGeode.get());
  mPAT->addChild(mBackgroundGeode.get());

  mText->setCharacterSize(characterSize);
  SetForegroundColor(fgColor);
  SetBackgroundColor(bgColor);
  
  DisableLightingAndBlending(mTextGeode.get());
  DisableLightingAndBlending(mBackgroundGeode.get());
}

void PokerLabelView::DisableLightingAndBlending(osg::Geode *geode)
{
  assert(geode != 0);
  osg::StateSet *sstate = geode->getOrCreateStateSet();
  sstate->setMode(GL_LIGHTING, osg::StateAttribute::OFF|osg::StateAttribute::OVERRIDE);
  osg::Material *material = dynamic_cast<osg::Material*>(sstate->getAttribute(osg::StateAttribute::MATERIAL));
  if (material) 
    {	    
      material->setAlpha(osg::Material::FRONT,1);
      sstate->setMode(GL_BLEND, osg::StateAttribute::OFF|osg::StateAttribute::OVERRIDE);
      sstate->setRenderingHint(osg::StateSet::OPAQUE_BIN);
    }
}
void PokerLabelView::syncLayout()
{
  mText->dirtyBound();
  const osg::BoundingBox bbox = mText->getBound();
  osg::Vec3 half = osg::Vec3(bbox.xMax()-bbox.xMin(), bbox.yMax()-bbox.yMin(), bbox.zMax()-bbox.zMin())/2.0f;
  mText->setPosition(-half);
  mText->dirtyBound();

  // todo remove new
  mBackgroundBox = new osg::Box();
  
  const osg::BoundingBox bbox1 = mText->getBound();
  osg::Vec3 half1 = osg::Vec3(bbox1.xMax()-bbox1.xMin(), bbox1.yMax()-bbox1.yMin(), bbox1.zMax()-bbox1.zMin())/2.0f;
  mBackgroundBox->setCenter(-osg::Vec3(0.f, 0.f, 0.1f));
  mBackgroundBox->setHalfLengths(half1);
  
  osg::Vec4 cl=mBackgroundDrawable->getColor();
  mBackgroundDrawable = new osg::ShapeDrawable(mBackgroundBox.get());
  mBackgroundDrawable->setColor(cl);
  mBackgroundDrawable->dirtyBound();
  mBackgroundGeode->setDrawable(0, mBackgroundDrawable.get());
}

void PokerLabelView::SetText(const std::string &text)
{
  mText->setText(text);
  syncLayout();
}

osg::Node *PokerLabelView::GetNode()
{
  return mPAT.get();
}

void PokerLabelView::SetCenter(const osg::Vec3 &pos)
{
  const osg::BoundingBox &bbox = mText->getBound();
  osg::Vec3 delta = osg::Vec3(bbox.xMax()-bbox.xMin(), bbox.yMax()-bbox.yMin(), bbox.zMax()-bbox.zMin())/2.0f;
  mPosition=pos-delta;
  mPAT->setPosition(pos);
}

void PokerLabelView::SetPosition(const osg::Vec3 &pos)
{
  mPosition = pos;
  const osg::BoundingBox &bbox = mText->getBound();
  osg::Vec3 delta = osg::Vec3(bbox.xMax()-bbox.xMin(), bbox.yMax()-bbox.yMin(), bbox.zMax()-bbox.zMin())/2.0f;
  mPAT->setPosition(pos + delta);
}

void PokerLabelView::SetForegroundColor(const osg::Vec4 &fgColor)
{
  mForegroundColor = fgColor;
  mText->setColor(fgColor);
}

void PokerLabelView::SetBackgroundColor(const osg::Vec4 &bgColor)
{
  // todo remove new
  mBackgroundColor = bgColor;
  mBackgroundDrawable = new osg::ShapeDrawable(mBackgroundBox.get());					       
  mBackgroundDrawable->setColor(bgColor);
  mBackgroundGeode->setDrawable(0, mBackgroundDrawable.get());
}

void PokerLabelView::SetCharacterSize(unsigned int characterSize)
{
  mText->setCharacterSize(characterSize);
  syncLayout();
}

PokerLabelController::PokerLabelController() : mFocused(false)
{
}

PokerLabelController::~PokerLabelController()
{
}

void PokerLabelController::HandleHit(MAFHit& hit)
{

}

void PokerLabelController::Init()
{
  SetView(new PokerLabelView());
  GetView()->Init();
  UGAMEArtefactController::Init();
  GetModel()->SetArtefact(GetView()->GetNode());
  SetSelectable(true);
}

void PokerLabelController::Init(PokerApplication *game, MAFOSGData *data, const std::string &path)
{
  Init();
}

bool PokerLabelController::Update(MAFApplication *application)
{
  bool focused = (application->GetFocus() == this);  

  UGAMEArtefactController::Update(application);
  bool enterFocused = focused && !mFocused;
  bool leaveFocused = !focused && mFocused;
  bool stayFocused = focused && mFocused;
  if (enterFocused)
    {
      OnEnter();
      OnFocus();
      mFocused = true;
    }
  else if (leaveFocused)
    {
      OnLeave();
      mFocused = false;
    }
  else if (stayFocused)
      OnFocus();

  if (GetSelected())
    {
      OnClick();
      SetSelected(false);
    }

  return true;
}

void PokerLabelController::AnchorByName(MAFOSGData *data, const std::string &name)
{
  assert(name.length() != 0);
  MAFAnchor *anchor = static_cast<MAFAnchor *>(data->GetNode(name));
  assert(anchor != 0);
  UGAMEArtefactController::Anchor(anchor);
}

void PokerLabelController::OnEnter()
{
  // put in model instead
  const osg::Vec4 &focusedColor = osg::Vec4(1.f, 0.f, 0.f, 1.f);
  GetView()->SetBackgroundColor(focusedColor);
}

void PokerLabelController::OnFocus()
{
}

void PokerLabelController::OnLeave()
{
  // put in model instead
  const osg::Vec4 &focusedColor = osg::Vec4(0.f, 0.f, 1.f, 1.f);
  GetView()->SetBackgroundColor(focusedColor);
}

void PokerLabelController::OnClick()
{
  GetView()->SetText("yopo");
}
