/*
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Cedric Pinson <cpinson@freesheep.org>
 */


#include "pokerStdAfx.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */
#ifdef WIN32
#include "config_win32.h"
#include <cstdio>
# define snprintf _snprintf
#endif

#include "PokerFoldAnimation.h"
#include "PokerApplication.h"
#include <maf/maferror.h>
#include <maf/utils.h>
#include <maf/MultipleAnimationPathCallback.h>
#include <string>
#include <sstream>

PokerFoldAnimation::PokerFoldAnimation(PokerApplication* game,MAFOSGData* seat) 
{
  mMoveCards=0;
  const std::string &source=game->HeaderGet("sequence", "/sequence/cardsfold/@source");
  if (source.empty())
    g_error("PokerFoldAnimation::PokerFoldAnimation /sequence/cardsfold/@source not found");

  if (!seat->GetAnchor(source))
    g_error("PokerFoldAnimation::PokerFoldAnimation anchor %s not found",source.c_str());
  mTransformPosition=seat->GetAnchor(source)->asTransform()->asMatrixTransform();
  mOriginalTransformShake=mTransformPosition->getMatrix();
  
  osg::MultipleAnimationPathCallback* cb=dynamic_cast<osg::MultipleAnimationPathCallback*>(mTransformPosition->getUpdateCallback());
  if (!cb)
    g_error("PokerFoldAnimation::PokerFoldAnimation update call back not found");
  mAnimationCallback=new osg::MultipleAnimationPathCallback(*cb);
  osg::AnimationPath* pt=mAnimationCallback->getAnimationPath();
  assert(pt);
  pt->setLoopMode(osg::AnimationPath::NO_LOOPING);

  mTransformPosition->setUpdateCallback(mAnimationCallback.get());
  mTransformPosition->setNodeMask(~(MAF_VISIBLE_MASK | MAF_COLLISION_MASK));


  const std::string &basename=game->HeaderGet("sequence", "/sequence/cardsfold/@card_basename");
  if (basename.empty())
    g_error("PokerFoldAnimation::PokerFoldAnimation /sequence/cardsfold/@card_basename not found");

  std::stringstream str;
  // get all cards under this transform (we assume that it's a transform)
  int nb=mTransformPosition->getNumChildren();
  for (int i=0;i<nb;i++) {
    str.str(std::string());
    str << basename << i;
    osg::Node* node=GetNode(mTransformPosition.get(),str.str());
    if (node) {
      osg::MatrixTransform* t=node->asGroup()->asTransform()->asMatrixTransform();
      if (t) {
	mCards.push_back(t);
	HideCard(mCards.size()-1);
      }
    }
  }
}


void PokerFoldAnimation::ShowCard(int i)
{
  g_assert(i>=0 && ((unsigned int)i)<mCards.size());
  mCards[i]->setNodeMask(MAF_VISIBLE_MASK);
}

void PokerFoldAnimation::HideCard(int i)
{
  g_assert(i>=0 && ((unsigned int)i)<mCards.size());
  mCards[i]->setNodeMask(~(MAF_VISIBLE_MASK | MAF_COLLISION_MASK));
}

void PokerFoldAnimation::StartSequence()
{
  mTransformPosition->setNodeMask(MAF_VISIBLE_MASK);
  mMoveCards=1;
  mAnimationCallback->setPause(false);
  mAnimationCallback->reset();

  g_debug("tremblements");
}

void PokerFoldAnimation::Update(const double dt)
{
  if (!mMoveCards)
    return;

  // cards end shakes so we start move cards
  if (!mAnimationCallback->isPlaying()) {
    mMoveCards=0;
    mTransformPosition->setNodeMask(~(MAF_VISIBLE_MASK | MAF_COLLISION_MASK));
    for (unsigned int i=0;i<mCards.size();i++)
      HideCard(i);
  }

}
