/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Johan Euphrosine <johan@mekensleep.com>
 *
 */

#ifndef __pokerdoor_h__
#define __pokerdoor_h__

#include <osg/Vec3>

#include <maf/controller.h>
#include <ugame/artefact.h>

#include <maf/interpolator.h>
#include "PokerApplication.h"

class PokerApplication;

class PokerDoorModel : public UGAMEArtefactModel
{
 public: 
  PokerDoorModel();
  void Init();
  MAFOSGData *mDoorData;
  osg::ref_ptr<osg::Node> mDoorCollNode;
  MAFBezierInterpolator<osg::Quat, util::slerp> mRotationInterpolator;
  MAFInterpolatorTimer<> mTimer;
};

class PokerDoorController : public UGAMEArtefactController
{
 public:
  PokerDoorController();
  ~PokerDoorController();
  void Init(PokerApplication *game, const std::string &path);
  bool Update(MAFApplication *game);
  PokerDoorModel *GetModel() { return static_cast<PokerDoorModel *>(UGAMEArtefactController::GetModel()); }
  void Enable();
  void Disable();
  void LoadKeys(std::vector<osg::Vec2> &keys, MAFXmlData *data, const std::string &name);
  template<typename T>
    void LoadSpline(T &interpolator, MAFXmlData *data, const std::string &name)
    {
      std::vector<osg::Vec2> keys;
      LoadKeys(keys, data, name);
      interpolator.InitKeys(keys);
    }
};

#endif //__pokerdoor_h_
