/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Johan Euphrosine <johan@mekensleep.com>
 *
 */

#include "pokerStdAfx.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */
#ifdef WIN32
#include "config_win32.h"
#endif

#include <sstream>
#include <iomanip>
#include <map>

#include <osg/Shape>
#include <osg/ShapeDrawable>
#include <osg/Geode>
#include <osg/MatrixTransform>
#include <osgUtil/IntersectVisitor>

#ifndef WIN32
#include <PokerDoor.h>
#include <PokerApplication.h>
#include <maf/interpolator.h>
#include <PokerError.h>
#endif

PokerDoorModel::PokerDoorModel() : mDoorData(0)
{
}

void PokerDoorModel::Init()
{
  UGAMEArtefactModel::Init();
  osg::Quat from(0.0f, osg::Vec3(0.0f, 1.0f, 0.0f));
  osg::Quat to(osg::PI_2, osg::Vec3(0.0f, 1.0f, 0.0f));
  mRotationInterpolator.Init(from, to);
  mTimer.Init(0.5);
}

PokerDoorController::PokerDoorController()
{
  SetModel(new PokerDoorModel());
}

PokerDoorController::~PokerDoorController()
{
  GetModel()->mDoorCollNode = 0;
  Anchor(0);

  delete (GetModel()->mDoorData);

  osg::NodeVisitor* leakNodes = RecursiveLeakCollect(GetModel()->GetNode());
  RecursiveLeakCheck(leakNodes); 
}

void PokerDoorController::Init(PokerApplication *game, const std::string &path)
{
  UGAMEArtefactController::Init();
#if 0
  const std::string &doorNodeName = game->HeaderGet("sequence", path + "/@url");
  const std::string &doorCollName = game->HeaderGet("sequence", path + "/@collide");
  const std::string &doorAnchorName = game->HeaderGet("sequence", path + "/@anchor");
  const std::string &splineUrl = "splines.xml";
  const std::string &splineName = game->HeaderGet("sequence", path + "/@spline");

  MAFOSGData *doorData = static_cast<MAFOSGData *>(game->mDatas->GetVision(doorNodeName)->Clone());
  g_assert(doorData != 0);
  osg::Node *doorNode = doorData->GetGroup();
  g_assert(doorNode != 0);
  GetModel()->SetArtefact(doorNode);
  GetModel()->mDoorData = doorData;

  MAFAnchor *doorAnchor = game->mSetData->GetAnchor(doorAnchorName);
  g_assert(doorAnchor != 0);

  osg::Node *doorCollNode = game->mSetData->GetNode(doorCollName);
  g_assert(doorCollNode != 0);
  GetModel()->mDoorCollNode = doorCollNode;

  MAFXmlData *data = game->mDatas->GetXml(splineUrl);
  LoadSpline(GetModel()->mRotationInterpolator, data, splineName);  

  BindToNode(doorCollNode);

  Anchor(doorAnchor);
  GetModel()->SetSelectable(true);
#else
  const std::string &doorNodeName = game->HeaderGet("sequence", path + "/@url");
  const std::string &doorCollName = game->HeaderGet("sequence", path + "/@collide");
  const std::string &doorAnchorName = game->HeaderGet("sequence", path + "/@anchor");
  const std::string &splineUrl = "splines.xml";
  const std::string &splineName = game->HeaderGet("sequence", path + "/@spline");

  MAFOSGData *doorData = static_cast<MAFOSGData *>(game->mDatas->GetVision(doorNodeName)->Clone());
  g_assert(doorData != 0);
  osg::Node *doorNode = doorData->GetGroup();
  g_assert(doorNode != 0);
  GetModel()->SetArtefact(doorNode);
  GetModel()->mDoorData = doorData;

  MAFAnchor *doorAnchor = game->mSetData->GetAnchor(doorAnchorName);
  g_assert(doorAnchor != 0);

  osg::Node *doorCollNode = game->mSetData->GetNode(doorCollName);
  g_assert(doorCollNode != 0);
  GetModel()->mDoorCollNode = doorCollNode;
  doorCollNode->setNodeMask(MAF_COLLISION_MASK);

  MAFXmlData *data = game->mDatas->GetXml(splineUrl);
  LoadSpline(GetModel()->mRotationInterpolator, data, splineName);

  BindToNode(doorCollNode);
  doorAnchor->setNodeMask(MAF_VISIBLE_MASK); // no collisions with door only with collid mesh
  Anchor(doorAnchor);
  GetModel()->SetSelectable(true);
#endif
}

bool PokerDoorController::Update(MAFApplication *game)
{
  UGAMEArtefactController::Update(game);

  if(game->HasEvent())
    return true;
  
  bool focused = (game->GetFocus() == this);

  float delta = GetDeltaFrame()/1000.f;
  delta = (focused ? delta : -delta);

  GetModel()->mTimer.AddTime(delta);

  osg::Quat rot;
  GetModel()->mTimer.Get(rot, GetModel()->mRotationInterpolator);
  GetModel()->GetPAT()->setAttitude(rot);
  
  return true;
}

void PokerDoorController::Enable()
{
  GetModel()->GetArtefact()->setNodeMask(0xffffffff);
  SetSelectable(true);
}

void PokerDoorController::Disable()
{
  GetModel()->GetArtefact()->setNodeMask(0);
  SetSelectable(false);
}

void PokerDoorController::LoadKeys(std::vector<osg::Vec2> &keys, MAFXmlData *data, const std::string &name)
{
  if (data != NULL) {
    const std::list<std::string> &xResultList = data->GetList("/splines/" + name + "/list/entry/@xvalue");
    const std::list<std::string> &yResultList = data->GetList("/splines/" + name + "/list/entry/@yvalue");
    
    g_assert(xResultList.size() == yResultList.size());
    typedef std::list<std::string>::const_iterator It;
    It xbegin = xResultList.begin();
    It xend = xResultList.end();
    
    It ybegin = yResultList.begin();
    It yend = yResultList.end();
    
    while(xbegin != xend) {
      keys.push_back(osg::Vec2(atof((*xbegin).c_str()), atof((*ybegin).c_str())));
      xbegin++;
      ybegin++;
    }
  }
}

