/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *
 */

#ifndef _pokercard_h
#define _pokercard_h

#include <vector>

#include <osg/Image>
#include <osg/NodeCallback>
#include <osg/CullStack>

#include <ugame/artefact.h>

#include <maf/data.h>

class PokerApplication;

typedef std::map<int,osg::ref_ptr<osg::Image> > PockerDeckMap;

class PokerDeck {
public:
  PokerDeck(PokerApplication* game);

  osg::Image* GetImage(int index);
  PockerDeckMap& GetMapTable() { return mImages; }

private:
  //std::map<int,osg::ref_ptr<osg::Image> > mImages;
	PockerDeckMap mImages;
};

class PokerCardModel : public UGAMEArtefactModel {
public:
  PokerCardModel(PokerApplication* game, const std::string& url);
  virtual ~PokerCardModel();

  virtual void Init(void);

  MAFOSGData* GetData(void) { return dynamic_cast<MAFOSGData*>(UGAMEArtefactModel::GetData()); }

  int GetValue(void);
  void SetValue(int value);

  bool GetVisible(void) { return mVisible; }
  void SetVisible(bool visible) { mVisible = visible; }

  float GetHeight(void);
  float GetWidth(void);

private:
  PokerApplication* mGame;
  int mValue;
  bool mVisible;
};

class PokerCardController : public UGAMEArtefactController {
public:
  PokerCardController(PokerApplication* game, const std::string& url);
  virtual ~PokerCardController() {}

  PokerCardModel* GetModel() { return dynamic_cast<PokerCardModel*>(UGAMEArtefactController::GetModel()); }

  void SetScale(float scale);
  int GetValue();
  void SetValue(int value);
  void Visible(bool visible);
  void Receive();
  void Fold();

private:
  PokerApplication* mGame;
};

typedef std::vector<osg::ref_ptr<PokerCardController> > PokerCardControllerVector;

class PokerCardsCallback : public osg::NodeCallback {
public:
  PokerCardsCallback();
  PokerCardsCallback(const PokerCardsCallback& pokerCards, const osg::CopyOp& copyop) : osg::NodeCallback(pokerCards, copyop) {}

  META_Object(poker,PokerCardsCallback);

  osg::PositionAttitudeTransform* FindTransform(osg::Node* node);
  void AutoScale(osg::Group* group, osg::CullStack* cs, float& width, float& height, float& width_on_screen, float& height_on_screen);

  virtual void operator()(osg::Node* node, osg::NodeVisitor* nv);

  void Dirty(void) { mEyePoint.set(0.f, 0.f, 0.f); }

  float GetElevateRatio(void) { return mElevateRatio; }
  void SetElevateRatio(float elevateRatio) { mElevateRatio = elevateRatio; }
  float GetPercentIntersect(void) { return mPercentIntersect; }
  void SetPercentIntersect(float precentIntersect) { mPercentIntersect = precentIntersect; }

  float GetPercentUp(void) { return mPercentUp; }
  void SetPercentUp(float percentUp) { mPercentUp = percentUp; }

  float GetScale(void) { return mScale; }
  void SetScale(float scale) { mScale = scale; }

  float GetScaleMin(void) { return mScaleMin; }
  void SetScaleMin(float scaleMin) { mScaleMin = scaleMin; }

  float GetScaleMax(void) { return mScaleMax; }
  void SetScaleMax(float scaleMax) { mScaleMax = scaleMax; }

  float GetDesiredHeight(void) { return mDesiredHeight; }
  void SetDesiredHeight(float desiredHeight) { mDesiredHeight = desiredHeight; }

  void SetControllers(PokerCardControllerVector& controllers);

private:
  float mElevateRatio;
  float mPercentIntersect;
  float mPercentUp;
  float mScale;
  float mScaleMin;
  float mScaleMax;
  float mDesiredHeight;
  std::map<osg::Node*,PokerCardController*> mNode2Controller;
  osg::Vec3 mEyePoint;
};

#endif // _pokercard_h
