/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *  Johan Euphrosine <johan@mekensleep.com>
 *  Cedric Pinson <cpinson@freesheep.org>
 *  Igor Kravtchenko <igor@obraz.net>
 */

#ifndef __POKERBODY_H
#define __POKERBODY_H

#include <ugame/animated.h>
#include <vector>
#include <string>

#include <cal3d/scheduler.h>
#include "perlin_noise.h"

#include <osg/TexMat>

class MAFVisionData;
class CardStartLooking;
class CardEndLooking;
class CardFolding;
class osg::Drawable;
class PokerDeck;
class NoiseElement;
class PlayFoldAnimation;
class PokerFoldAnimation;
class MAFAudioController;
//Model


class PokerBodyModel : public UGAMEAnimatedModel
{  
  struct CardEntry {
    osg::ref_ptr<osg::Drawable> back;
    osg::ref_ptr<osg::Drawable> front;
  };


  std::map<int,osg::ref_ptr<MAFAudioController> > mAnimation2Sounds;

 public:
  PlayFoldAnimation* mFoldAnimation; 
  PokerFoldAnimation* mFoldSequence;

  PokerBodyModel(MAFApplication* application,MAFVisionData *data,MAFOSGData* seat);
  virtual ~PokerBodyModel();
  virtual void Init();

  // to be called from a python packet
  // animation is the animation fold selected by the python side
  void PlayFold(const std::string& foldAnimation);

  void ShowCard(int i);
  void HideCard(int i);
  int PlayStandUp();
  void PlayBreath(float time);
  void PlayBlink();
  void PlayWin();
  void PlayLoose();
  void PlayStanding();
  double PlayStartLookCards();
  double PlayEndLookCards();
  void PlayLookAt(const osg::Vec3& directionOfPlayerorigin,
		  const osg::Vec3& positionOfPlayer, 
		  const osg::Vec3& target);
  void PlayLookAt(const osg::Vec3& origin, const osg::Vec3& target);
  void BuildQuaternionFromTarget(const osg::Vec3& _origin, const osg::Vec3& _target,CalQuaternion& _result);
  void BuildQuaternionFromTarget(const osg::Vec3& _dir,const osg::Vec3& _origin, const osg::Vec3& _target,CalQuaternion& _result);
  void PlayFacialNoise();
  void StopFacialNoise();
  void Stop();
  void StopAll();
  void InitCardsOfPlayer();
  void DettachCardsDrawableToPlayer();
  void UpdateCardsOfPlayer(const std::vector<int>& cards);
  void DisableCurrentAnimationCallback(const std::string &name);
  void DisableCurrentAnimationCallback(int id);
  void EnableAnimations(void) { mAnimationsEnabled = true; }
  void DisableAnimations(void) { mAnimationsEnabled = false; }
  int GetNbCardsDisplayed();

  bool mMe;
  bool mLoopBreath;
  CardStartLooking* mStartLookCards;
  CardEndLooking* mEndLookCards;
  CardFolding *mFoldCards;
  std::vector<CardEntry> mCards;
  PokerDeck* mDeck;
  int mNbCardsToPlay;
  std::string mDataPath;
  int mLookatId;
  std::vector<NoiseElement*> mNoiseAnimations;
  std::string mFocus;
  float mMinAlpha;
  float mAngleAlpha;
  float mCurrentAlpha;
  bool mAnimationsEnabled;
  int mNumberOfCardsReady; // number of cards the player have to play

  osg::TexMat *texmatL_;
  osg::TexMat *texmatR_;

  std::vector<std::string> mEyesMeshName;


  void SetAlpha(float alpha);
  float GetAlpha() const { return mCurrentAlpha;}
  float ComputeAlphaFromDirection(const osg::Vec3 camDirection);

  int IsPlayingAnimationList(const std::vector<std::string, std::allocator<std::string> >&);
  void BuildAnimationSoundMap(std::map<std::string,osg::ref_ptr<MAFAudioController> >& source);
};

//Controller

class PokerBodyController : public UGAMEAnimatedController
{
 public:
  PokerBodyController(MAFApplication* application,MAFVisionData *data,MAFOSGData* seat);
  PokerBodyModel *GetModel() { return static_cast<PokerBodyModel *>(UGAMEAnimatedController::GetModel()); }

  void HandleHit(MAFHit& hit);
  bool Update(MAFApplication* application);
  void SetMe(bool value) { GetModel()->mMe = value; }
  void SetUseVertexProgram(bool value) { GetModel()->GetArtefact()->setUseVertexProgram(value); }
  void SetDeck(PokerDeck *deck) { GetModel()->mDeck = deck; }
  void SetNbCards(int i) { GetModel()->mNbCardsToPlay = i; }
  int GetNbCards() { return GetModel()->mNbCardsToPlay; }
  void SetDataPath(const std::string &data) { GetModel()->mDataPath = data; }
  void PlayBreath(float time) { GetModel()->PlayBreath(time); }
  void PlayBlink() { GetModel()->PlayBlink(); }
  void PlayWin() { GetModel()->PlayWin(); }
  int PlayStandUp() { return GetModel()->PlayStandUp(); }
  void PlayLoose() { GetModel()->PlayLoose(); }
  double PlayStartLookCards() { return GetModel()->PlayStartLookCards(); }
  void PlayStanding() { GetModel()->PlayStanding(); }
  double PlayEndLookCards() { return GetModel()->PlayEndLookCards(); }
  void PlayLookAt(const osg::Vec3& directionOfPlayerorigin,
		  const osg::Vec3& positionOfPlayer, 
		    const osg::Vec3& target) { GetModel()->PlayLookAt(directionOfPlayerorigin, positionOfPlayer, target); }
  void PlayLookAt(const osg::Vec3& origin, const osg::Vec3& target) { GetModel()->PlayLookAt(origin, target); }
  void PlayFacialNoise() { GetModel()->PlayFacialNoise(); }
  void StopFacialNoise() { GetModel()->StopFacialNoise(); }
  void StopAll() { GetModel()->StopAll(); }
  void InitCardsOfPlayer() { GetModel()->InitCardsOfPlayer(); }
  void DettachCardsDrawableToPlayer() { GetModel()->DettachCardsDrawableToPlayer(); }
  void UpdateCardsOfPlayer(const std::vector<int>& cards) { GetModel()->UpdateCardsOfPlayer(cards); }
  void DisableCurrentAnimationCallback(const std::string &name) { GetModel()->DisableCurrentAnimationCallback(name); }
  void DisableCurrentAnimationCallback(int id) { GetModel()->DisableCurrentAnimationCallback(id); }
  const std::string &GetFocus() { return GetModel()->mFocus; }
  void AddTimeSitIn(float time);
  void AddTimeSitOut(float time);
  void AddTimeSit(int id, float time);
};



class PlayFoldAnimation : public CalScheduler::StopCallback
{
 protected:
  PokerBodyModel* mBody;

 public:
  PlayFoldAnimation(PokerBodyModel* body):mBody(body) {}
  void process(CalModel* model, CalAnimationAlt* animation);
};


class CardStartLooking : public CalScheduler::StopCallback
{
 protected:
  PokerBodyModel* mBody;
 public:
  CardStartLooking(PokerBodyModel* body);
  void Look();
  void process(CalModel* model, CalAnimationAlt* animation);
  void Init() {}
};

class CardEndLooking : public CardStartLooking
{
 public:
  CardEndLooking(PokerBodyModel* body) : CardStartLooking(body){}
  void Look();
  void process(CalModel* model, CalAnimationAlt* animation);
};

class CardFolding : public CalScheduler::StopCallback
{
  PokerBodyModel* mBody;
 public:
  CardFolding(PokerBodyModel* body);
  void Fold();
  void process(CalModel* model, CalAnimationAlt* animation);
};

class NoiseElement : public CalAnimationAlt::StopCallback
{
 protected:
  CalCoreAnimation* mCoreAnimation;
  int mCoreAnimationId;
  bool mKeepGoing;
  CalModel* mModel;
  PerlinNoise1D mNoise;
  std::string mDatadir;

  double Noise(double _t,float _amp,float _freq);

  virtual double NoiseFunction(double _t);

  CalCoreBone* GetCoreBone(int boneId);

  void CreateCoreAnimation(const std::string& path, std::list<std::string>& bones);

 public:
  virtual ~NoiseElement() {}
  NoiseElement(CalModel* model, const std::string& datadir);

  void SetKeepGoing(bool keepGoing) { mKeepGoing = keepGoing; }

  virtual void process(CalModel* model, CalAnimationAlt* animation) = 0;
  int GetCoreAnimationId() { return mCoreAnimationId;}
};


#endif // __POKERBODY_H
