/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *  Henry Prcheur <henry@precheur.org>
 *  Cedric Pinson <cpinson@freesheep.org>
 *
 */

#ifndef _poker_h
#define _poker_h

#include <map>
#include <vector>

#include <maf/model.h>
#include <maf/view.h>
#include <maf/controller.h>

#include <PokerCard.h>
#include <PokerSeat.h>
#include <PokerPot.h>
#include <PokerDoor.h>

#define POKER_SERVER_STATE_NULL		0
#define POKER_SERVER_STATE_BEGIN	1
#define POKER_SERVER_STATE_FLOP		2
#define POKER_SERVER_STATE_TURN		3
#define POKER_SERVER_STATE_RIVER	4

class PokerApplication;
class PokerPlayer;
class PokerButtonController;
class PokerSeatManager;
class PokerDoorController;
class MAFPacket;
class PokerMoveChipsBase;
class PokerBoardController;

class PokerModel : public MAFModel
{
public:
  PokerModel(PokerApplication* game);
  virtual ~PokerModel();
  
  typedef std::map<guint,osg::ref_ptr<PokerPlayer> > Serial2Player;
  Serial2Player mSerial2Player;
  std::vector<osg::ref_ptr<PokerPlayer> > mSeat2Player;
  std::vector<guint> mSeat2Serial;
  std::list<osg::ref_ptr<UGAMEArtefactController> > mArtefacts;
  osg::ref_ptr<PokerSeatManager> mSeatManager;
  osg::ref_ptr<PokerPotController> mPotCenter;
  osg::ref_ptr<PokerDoorController> mFrontDoor;
  osg::ref_ptr<PokerDoorController> mBackDoor;
  osg::ref_ptr<osg::Node> mDealerButton;

  int mCurrent1Card;
  int mDealCard;
  float mDealTime;
  guint mLastPlayerDealedCard;
  
  osg::ref_ptr<PokerBoardController> mBoard;

  float mParamTimeToDealCard;
  int mNbCardToDealPerPlayer;

  std::map<int,int> mChipValue2Index;
  unsigned mPosition;
  int mSeats;
  guint	mMe;
  int mServerState;
  int mGameSerial;
  bool	mShowStackToolTip;
  PokerApplication* mGame;

  struct PokerMoveChipsCommand
  {
    int mSerial;
    std::vector<int> mChips;
    int mIndex;
    PokerMoveChipsCommand(int serial,const std::vector<int>& chips,int index):mSerial(serial),mChips(chips),mIndex(index){}
    int IsEmpty() {
      int res=0;
      for (std::vector<int>::iterator i=mChips.begin();i!=mChips.end();i++)
	res+=(*i);
      return res == 0;
    }
  };

  class PokerTrackActiveMoveChips : public osg::Referenced
  {
  protected:
    ~PokerTrackActiveMoveChips(){}
  public:
    
    struct EntryElement
    {
      guint mSerial;
      PokerMoveChipsBase* mAnimation;
      EntryElement(guint serial,PokerMoveChipsBase* animation):mSerial(serial),mAnimation(animation){}
    };

    PokerTrackActiveMoveChips(std::map<guint,osg::ref_ptr<PokerPlayer> >& serial):mSerial2Player(serial){}
    
    bool HasAnimation();
    void RemoveFinishedEntry();
    void AddEntry(const EntryElement& entry) {
      mActives.push_back(entry);
    }

    std::vector<EntryElement> mActives;
    std::map<guint,osg::ref_ptr<PokerPlayer> >& mSerial2Player;    
  };


//   struct DealCardAnimation{
//     guint mSerial;
//     int mCardNumber;
//     DealCardAnimation(guint serial,int card):mSerial(serial),mCardNumber(card){}
//   };


  std::vector<PokerMoveChipsCommand> mBet2PotCommand;
  std::vector<PokerMoveChipsCommand> mPot2PlayerCommand;
  void SortStack(std::vector<PokerMoveChipsCommand>& stackToSort,bool toPlayer);

  osg::ref_ptr<PokerTrackActiveMoveChips> mActiveBet2Pot;
  osg::ref_ptr<PokerTrackActiveMoveChips> mActivePot2Player;

  bool IsAnyChipsToMoveToPot();
  bool IsAnyChipsToMoveToPlayer();

  float RunChipsAnimationBet2Pot();
  float RunChipsAnimationPot2Player();


  std::vector<int> mDealPlayerCards;
  int mCurrentPlayerToSendCard;

  bool mEventRunAnimationProcess;

  // sound data 
  // no cat for the demo
#if 0
  osg::ref_ptr<MAFAudioController> mSoundEndGame;
#endif
  guint	mGameId;
};

typedef MAFView PokerView;

class PokerController : public MAFController
{
public:
  PokerController(PokerApplication* game);
  virtual ~PokerController();

  PokerModel* GetModel() { return dynamic_cast<PokerModel*>(MAFController::GetModel()); }

  void SetPot(const std::vector<int>& amount,int index=0);
  void SetCards(const std::vector<int>& cards); 
  void FoldCards(void); 
  virtual bool Update(MAFApplication* application);
  void PythonAccept(MAFPacket* packet);

#ifdef TEST_PERFORMANCE
  int mPerfCharacteres;
#endif
};

#endif // _poker_h
