#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <setjmp.h>
#include <errno.h>

#include "sys/wcetypes.h"
#include "sys/wceerror.h"
#include "sys/wcetrace.h"

static jmp_buf exitjmp;
static int exitcode;

int
_initexit()
{
  setjmp(exitjmp);
  return(0);
}

int
_getexitcode()
{
  return(exitcode);
}

int
_setexitcode(int code)
{
  exitcode = code;
}

void
abort(void)
{
  longjmp(exitjmp, 1);
}

int
_exit(int code)
{
  exitcode = code;

  longjmp(exitjmp, 1);
}

