/*
    pmacct (Promiscuous mode IP Accounting package)
    pmacct is Copyright (C) 2003-2005 by Paolo Lucente
*/

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <sys/poll.h>

/* defines */
#define NUM_MEMORY_POOLS 16
#define MEMORY_POOL_SIZE 8192
#define MAX_HOSTS 32771 
#define MAX_QUERIES 4096

/* Structures */
struct acc {
#if defined (HAVE_L2)
  u_int8_t eth_dhost[ETH_ADDR_LEN];
  u_int8_t eth_shost[ETH_ADDR_LEN];
  u_int16_t vlan_id;
#endif
  struct host_addr src_ip;
  struct host_addr dst_ip;
  u_int16_t src_port;
  u_int16_t dst_port; 
  u_int8_t tos;
  u_int8_t proto;
  u_int16_t id;
  u_int32_t bytes_counter;
  u_int32_t packet_counter;
  u_int32_t flow_counter;
  unsigned int signature;
  u_int8_t reset_flag;
  struct acc *next;
};

struct bucket_desc {
  unsigned int num;
  unsigned short int howmany;
};

struct memory_pool_desc {
  int id;
  unsigned char *base_ptr;
  unsigned char *ptr;
  int space_left;
  int len;
  struct memory_pool_desc *next;
};

struct query_header {
  int type;			/* type of query */
  u_int32_t what_to_count;	/* aggregation */
  unsigned int num;		/* number of queries */
  char passwd[8];		/* OBSOLETED: password */
};

struct query_entry {
  u_int32_t what_to_count;	/* aggregation */
  struct pkt_primitives data;	/* actual data */
};

struct reply_buffer {
  unsigned char buf[LARGEBUFLEN];
  unsigned char *ptr;
  int len;
  int packed; 
};

/* prototypes */
#if (!defined __ACCT_C)
#define EXT extern
#else
#define EXT
#endif
EXT void insert_accounting_structure(struct pkt_data *);
EXT struct acc *search_accounting_structure(struct pkt_primitives *);
#undef EXT

#if (!defined __MEMORY_C)
#define EXT extern
#else
#define EXT
#endif
EXT void init_memory_pool_table();
EXT void clear_memory_pool_table();
EXT struct memory_pool_desc *request_memory_pool(int);
#undef EXT

#if (!defined __SERVER_C)
#define EXT extern
#else
#define EXT
#endif
EXT void set_reset_flag(struct acc *);
EXT void reset_counters(struct acc *);
EXT int build_query_server(char *);
EXT void process_query_data(int, unsigned char *, int, int);
EXT void mask_elem(struct pkt_primitives *, struct acc *, u_int32_t);
EXT void enQueue_elem(int, struct reply_buffer *, void *, int);
EXT void Accumulate_Counters(struct pkt_data *, struct acc *);
#undef EXT

#if (!defined __IMT_PLUGIN_C)
#define EXT extern
#else
#define EXT
#endif
EXT void sum_host_insert(struct pkt_data *);
EXT void sum_port_insert(struct pkt_data *);
#if defined HAVE_L2
EXT void sum_mac_insert(struct pkt_data *);
#endif
EXT void exit_now(int);
#undef EXT

/* global vars */
#if (!defined __IMT_PLUGIN_C && !defined __PMACCT_CLIENT_C)
#define EXT extern
#else
#define EXT
#endif
EXT void (*insert_func)(struct pkt_data *); /* pointer to INSERT function */
EXT unsigned char *mpd;  /* memory pool descriptors table */
EXT unsigned char *a;  /* accounting in-memory table */
EXT struct memory_pool_desc *current_pool; /* pointer to currently used memory pool */
EXT struct acc **lru_elem_ptr; /* pointer to Last Recently Used (lru) element in a bucket */
EXT int no_more_space;
#undef EXT
