/*  
    pmacct (Promiscuous mode IP Accounting package)
    pmacct is Copyright (C) 2004 by Paolo Lucente
*/

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


/* includes */
#include "pmacct.h"

/* extern */
extern struct plugins_list_entry *plugin_list;

/* functions */
void handle_falling_child()
{
  while (waitpid(-1, NULL, WNOHANG) > 0);
}

void my_sighup_handler(int signum)
{
  got_hup_signal = TRUE;
}

void my_sigalrm_handler(int signum)
{
  got_alrm_signal = TRUE;
  alarm(config.sql_refresh_time);
}

void my_sigint_handler(int signum)
{
  struct plugins_list_entry *list = plugins_list;

  if (config.syslog) closelog();

  if (pcap_stats(glob_pcapt, &ps) < 0) printf("\npcap_stats: %s\n", pcap_geterr(glob_pcapt));
  printf("\n%d packets received by filter\n", ps.ps_recv);
  printf("%d packets dropped by kernel\n", ps.ps_drop);

  while (list) {
    if (memcmp(list->type.string, "core", sizeof("core"))) kill(list->pid, SIGINT);
    list = list->next;
  }

  wait(NULL);
  exit(0);
}

void reload()
{
  int logf;

  if (config.syslog) {
    closelog();
    logf = parse_log_facility(config.syslog);
    if (logf == ERR) {
      config.syslog = NULL;
      Log(LOG_WARNING, "WARN: specified syslog facility is not supported; logging to console.\n");
    }
    openlog(NULL, LOG_PID, logf);
    Log(LOG_INFO, "INFO: Start logging ...\n");
  }
}

