/*
    pmacct (Promiscuous mode IP Accounting package)
    pmacct is Copyright (C) 2004 by Paolo Lucente
*/

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "cfg_handlers.h"

/* defines */
#define CFG_LINE_LEN(x) (SRVBUFLEN-strlen(x))

/* structures */
struct _dictionary_line {
  char key[SRVBUFLEN];
  int (*func)(char *, char *);
};

struct configuration {
  int pipe_size;
  int buffer_size;
  char *imt_plugin_path;
  char *imt_plugin_passwd;
  char *sql_db;
  char *sql_table;
  char *sql_user;
  char *sql_passwd;
  char *sql_host;
  char *sql_data;
  char *sql_backup_host;
  int sql_optimize_clauses;
  int sql_refresh_time;
  int sql_history;
  int sql_history_howmany;
  int sql_startup_delay;
  int sql_cache_entries;
  char *sql_history_roundoff;
  char *sql_recovery_logfile;
  int promisc; /* pcap_open_live() promisc parameter */
  char *clbuf; /* pcap filter */
  char *dev;
  int num_memory_pools;
  int memory_pool_size;
  int buckets;
  int daemon;
  int active_plugins;
  char *pidfile; 
  char *networks_file;
  unsigned int what_to_count;
  char *a_filter;
  struct bpf_program bpfp_a_filter;
  char *syslog;
  int debug;
};

struct plugin_type_entry {
  char string[10];
  void (*func)(int, struct configuration *);
};

struct plugins_list_entry {
  int id;
  unsigned int pid;
  char name[SRVBUFLEN];
  struct configuration cfg;
  int pipe[2];
  struct plugin_type_entry type;
  struct plugins_list_entry *next;
};

/* prototypes */ 
#if (!defined __CFG_C)
#define EXT extern
#else
#define EXT
#endif
EXT void evaluate_configuration(int);
EXT int parse_configuration_file(char *);
EXT int parse_plugin_names(int, int);
EXT void debug_configuration_file(int);
EXT int create_plugin(char *, char *);
EXT int delete_plugin_by_id(int);
EXT struct plugins_list_entry *search_plugin_by_pipe(int);
EXT void sanitize_cfg(int);
EXT void set_default_values();

/* global vars */
EXT char cfg[SRVBUFLEN][SRVBUFLEN];
EXT int rows;
#undef EXT
