#lang scribble/doc
@(require scribble/manual
          "utils.ss"
          (for-label scribble/scheme))

@title[#:tag "scheme"]{Scheme}

@defmodule[scribble/scheme]{The @scheme[scribble/scheme] library
provides utilities for typesetting Scheme code. The
@scheme[scribble/manual] forms provide a higher-level interface.}

@defform*[[(define-code id typeset-expr)
           (define-code id typeset-expr uncode-id)
           (define-code id typeset-expr uncode-id d->s-expr)
           (define-code id typeset-expr uncode-id d->s-expr stx-prop-expr)]]{

Binds @scheme[id] to a form similar to @scheme[scheme] or
@scheme[schemeblock] for typesetting code. The form generated by
@scheme[define-code] handles source-location information, escapes via
@scheme[unquote], preservation of binding and property information,
and @tech{element transformers}.

The supplied @scheme[typeset-expr] expression should produce a
procedure that performs the actual typesetting. This expression is
normally @scheme[to-element] or @scheme[to-paragraph]. The argument
supplied to @scheme[typeset-expr] is normally a syntax object, but
more generally it is the result of applying @scheme[d->s-expr].

The optional @scheme[uncode-id] specifies the escape from literal code
to be recognized by @scheme[id]. The default is @scheme[unsyntax].

The optional @scheme[d->s-expr] should produce a procedure that
accepts three arguments suitable for @scheme[datum->syntax]: a syntax
object or @scheme[#f], an arbitrary value, and a vector for a source
location. The result should record as much or as little of the
argument information as needed by @scheme[typeset-expr] to typeset the
code. Normally, @scheme[d->s-expr] is @scheme[datum->syntax].

The @scheme[stx-prop-expr] should produce a procedure for recording a
@scheme['paren-shape] property when the source expression uses with
@scheme[id] has such a property. The default is
@scheme[syntax-property].}

@defproc[(to-paragraph [v any/c]) block?]{

Typesets an S-expression that is represented by a syntax object, where
source-location information in the syntax object controls the
generated layout.

Identifiers that have @scheme[for-label] bindings are typeset and
hyperlinked based on definitions declared elsewhere (via
@scheme[defproc], @scheme[defform], etc.). The identifiers
@schemeidfont{code:line}, @schemeidfont{code:comment}, and
@schemeidfont{code:blank} are handled as in @scheme[schemeblock], as
are identifiers that start with @litchar{_}.

In addition, the given @scheme[v] can contain @scheme[var-id],
@scheme[shaped-parens], @scheme[just-context], or
@scheme[literal-syntax] structures to be typeset specially (see each
structure type for details), or it can contain @scheme[element]
structures that are used directly in the output.}


@defproc[((to-paragraph/prefix [prefix1 any/c] [prefix any/c] [suffix any/c])
          [v any/c]) 
          block?]{

Like @scheme[to-paragraph], but @scheme[prefix1] is prefixed onto the
first line, @scheme[prefix] is prefix to any subsequent line, and
@scheme[suffix] is added to the end. The @scheme[prefix1],
@scheme[prefix], and @scheme[suffix] arguments are used as
@tech{content}, except that if @scheme[suffix] is a list of elements,
it is added to the end on its own line.}


@defproc[(to-element [v any/c]) element?]{

Like @scheme[to-paragraph], except that source-location information is
mostly ignored, since the result is meant to be inlined into a
paragraph.}

@defproc[(to-element/no-color [v any/c]) element?]{

Like @scheme[to-element], but @scheme[for-syntax] bindings are
ignored, and the generated text is uncolored. This variant is
typically used to typeset results.}


@defstruct[var-id ([sym (or/c symbol? identifier?)])]{

When @scheme[to-paragraph] and variants encounter a @scheme[var-id]
structure, it is typeset as @scheme[sym] in the variable font, like
@scheme[schemevarfont]---unless the @scheme[var-id] appears under
quote or quasiquote, in which case @scheme[sym] is typeset as a symbol.}


@defstruct[shaped-parens ([val any/c]
                          [shape char?])]{

When @scheme[to-paragraph] and variants encounter a
@scheme[shaped-parens] structure, it is typeset like a syntax object
that has a @scheme['paren-shape] property with value @scheme[shape].}


@defstruct[just-context ([val any/c]
                         [context syntax?])]{

When @scheme[to-paragraph] and variants encounter a
@scheme[just-context] structure, it is typeset using the
source-location information of @scheme[val] just the lexical context
of @scheme[ctx].}


@defstruct[literal-syntax ([stx any/c])]{

When @scheme[to-paragraph] and variants encounter a
@scheme[literal-syntax] structure, it is typeset as the string form of
@scheme[stx]. This can be used to typeset a syntax-object value in the
way that the default printer would represent the value.}


@defproc[(element-id-transformer? [v any/c]) boolean?]{

Provided @scheme[for-syntax]; returns @scheme[#t] if @scheme[v] is an
@tech{element transformer} created by
@scheme[make-element-id-transformer], @scheme[#f] otherwise.}


@defproc[(make-element-id-transformer [proc (syntax? . -> . syntax?)])
         element-id-transformer?]{

Provided @scheme[for-syntax]; creates an @deftech{element
transformer}.  When an identifier has a transformer binding to an
@tech{element transformer}, then forms generated by
@scheme[define-code] (including @scheme[scheme] and
@scheme[schemeblock]) typeset the identifier by applying the
@scheme[proc] to the identifier. The result must be an expression
whose value, typically an @scheme[element], is passed on to functions
like @scheme[to-paragraph] .}

@defproc[(variable-id? [v any/c]) boolean?]{

Provided @scheme[for-syntax]; returns @scheme[#t] if @scheme[v] is an
@tech{element transformer} created by @scheme[make-variable-id],
@scheme[#f] otherwise.}


@defproc[(make-variable-id [sym (or/c symbol? identifier?)])
         variable-id?]{

Provided @scheme[for-syntax]; like @scheme[make-element-id-transformer] for
a transformer that produces @scheme[sym] typeset as a variable (like
@scheme[schemevarfont])---unless it appears under quote or quasiquote,
in which case @scheme[sym] is typeset as a symbol.}

@deftogether[(
@defthing[output-color style?]
@defthing[input-color style?]
@defthing[input-background-color style?]
@defthing[no-color style?]
@defthing[reader-color style?]
@defthing[result-color style?]
@defthing[keyword-color style?]
@defthing[comment-color style?]
@defthing[paren-color style?]
@defthing[meta-color style?]
@defthing[value-color style?]
@defthing[symbol-color style?]
@defthing[variable-color style?]
@defthing[opt-color style?]
@defthing[error-color style?]
@defthing[syntax-link-color style?]
@defthing[value-link-color style?]
@defthing[module-color style?]
@defthing[module-link-color style?]
@defthing[block-color style?]
@defthing[highlighted-color style?]
)]{

Styles that are used for coloring Scheme programs, results, and I/O.}
