

//////////////////////////////////////////////////////////////////
//                                                              //
//           PLINK (c) 2005-2008 Shaun Purcell                  //
//                                                              //
// This file is distributed under the GNU General Public        //
// License, Version 2.  Please see the file COPYING for more    //
// details                                                      //
//                                                              //
//////////////////////////////////////////////////////////////////


#include <iostream>
#include <sstream>

#include "plink.h"
#include "helper.h"
#include "options.h"
#include "sockets.h"

using namespace std;

extern string PVERSION;


#define  PORT_NUM                80     
#define  IP_ADDR    "132.183.161.22"  
#define  GET_STRING "GET /~purcell/plink/version2.txt HTTP/1.1\nHost: pngu.mgh.harvard.edu\nConnection: close\n\n"


void Plink::webcheck(CArgs & a)
{

#ifdef SKIP
  printLOG("Web-check not implemented on this system...\n");
  return;
#else
  
  printLOG("Web-based version check ( --noweb to skip )\n");
  
  vector<string> tokens = socketConnection( this , 
					    IP_ADDR,
					    PORT_NUM,
					    GET_STRING);
					    
  bool print = false;
  bool print2 = false;
  bool version_okay = true;

  for (int i=0; i<tokens.size(); i++)
    {

      if (tokens[i]=="END") break;

      if (tokens[i]=="END-MESSAGE")
	{
	  print2=false;
	  continue;
	}

      if (tokens[i]=="WARN")
	{
	  if ( i < tokens.size()-1 ) 
	    {
	      i++;
	      if ( a.find(tokens[i]) )
		{
		  printLOG("\n*** ALERT ***\n*** A warning flag has been set for: "+tokens[i]+
			   "\n*** See http://pngu.mgh.harvard.edu/purcell/plink/warnings.shtml\n");
		  warnings = true;
		}
	    }
	  continue;
	}
      
      
      if (tokens[i]=="FATAL")
	{
	  if ( i < tokens.size()-1 ) 
	    {
	      i++;
	      if ( a.find(tokens[i]) )
		error("A serious warning flag has been set for: "+tokens[i]+
		    "\nPLINK has been instructed to stop"+
 	            "\nPlease see http://pngu.mgh.harvard.edu/purcell/plink/warnings.shtml\n");
	    }
	  continue;
	}


      if (tokens[i]=="MESSAGE-ALL")
	{
	  print2=true;
	  continue;
	}

      // Display any other messages
      // Either conditional on old version (print)
      // or a broadcast to all users (print2)

      if ( ( print && !version_okay) || print2 ) 
	{
	  if (tokens[i]=="\\n")
	    printLOG("\n");
	  else
	    printLOG(tokens[i]+" ");
	}

      // Check version code
      if (tokens[i]=="PLINK-VERSION") 
	{
	  print=true;
	  if ( i < tokens.size() - 1) 
	    {
	      if (tokens[i+1] == PVERSION)
		printLOG(" OK, v"+PVERSION+" is current\n");
	      else
		{
		  printLOG("\n\n          *** UPDATE REQUIRED ***\n\n");
		  printLOG("\tThis version        : "+PVERSION+"\n");
		  printLOG("\tMost recent version : "+tokens[i+1]+"\n\n");
		  printLOG("Please upgrade your version of PLINK as soon as possible!\n"); 
		  printLOG("  (visit the above website for free download)\n\n");
		  version_okay=false;
		}

	      // Skip the version number
	      i++;
	    }
	}

    }

  // did we get the information we needed?
  if (!print) printLOG("Problem connecting to web\n");

  printLOG("\n");

#endif  
}

