/*
  Plee the Bear

  Copyright (C) 2005-2010 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file throwable_items_container.hpp
 * \brief The set of throwable_items that Plee can throw.
 * \author Angibaud Sebastien
 */
#ifndef __PTB_THROWABLE_ITEMS_CONTAINER_HPP__
#define __PTB_THROWABLE_ITEMS_CONTAINER_HPP__

#include "ptb/throwable_item/throwable_item.hpp"
#include "universe/types.hpp"

#include <vector>

namespace ptb
{
  class player;

  /**
   * \brief The set of throwable_items that Plee can throw.
   * \author Sebastien Angibaud
   */
  class throwable_items_container
  {
  public:
    throwable_items_container(player* p);
    ~throwable_items_container();

    bool has_next() const;
    bool has_previous() const;
    void next();
    void previous();

    void control_current_throwable_item();
    void select(throwable_item::throwable_item_type t);
    throwable_item* get_current_throwable_item();
    const throwable_item* get_current_throwable_item() const;


  private:
    /* \brief The current throwable_item. */
    unsigned int m_current_throwable_item;

    /* \brief The set of throwable_items. */
    std::vector<throwable_item*> m_throwable_items;
  }; // class throwable_items_container
} // namespace ptb

#endif // __PTB_THROWABLE_ITEMS_CONTAINER_HPP__
