/*
  Plee the Bear

  Copyright (C) 2005-2010 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file throwable_item.cpp
 * \brief Implementation of the ptb::throwable_item class.
 * \author Sebastien Angibaud
 */
#include "ptb/throwable_item/throwable_item.hpp"

#include "ptb/player.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Contructor.
 * \param p The pointer on the player.
 */
ptb::throwable_item::throwable_item(player* p)
  : m_player(p), m_always_appear(false)
{
} // throwable_item::throwable_item()

/*----------------------------------------------------------------------------*/
/**
 * \brief Destructor.
 */
ptb::throwable_item::~throwable_item()
{
} // throwable_item::~throwable_item()

/*----------------------------------------------------------------------------*/
/**
 * \brief Create the throwable_item.
 */
bear::engine::base_item* ptb::throwable_item::create_throwable_item() const
{
  return NULL;
} // throwable_item::create_throwable_item()

/*----------------------------------------------------------------------------*/
/**
 * \brief Indicates if Plee can throw this throwable_item.
 */
bool ptb::throwable_item::can_throw() const
{
  return (get_stock() > 0);
}// throwable_item::can_throw()

/*----------------------------------------------------------------------------*/
/**
 * \brief Indicates if this throwable_item must be in the list of possible
 *        throwable_items.
 */
bool ptb::throwable_item::appears() const
{
  return (get_stock() > 0) || m_always_appear;
}// throwable_item::appears()

/*----------------------------------------------------------------------------*/
/**
 * \brief Decrease the stock.
 */
void ptb::throwable_item::decrease_stock() const
{
} // throwable_item::decrease_stock()

/*----------------------------------------------------------------------------*/
/**
 * \brief Get the stock of this throwable_item.
 */
unsigned int ptb::throwable_item::get_stock() const
{
  return 0;
} // throwable_item::get_stock()

/*----------------------------------------------------------------------------*/
/**
 * \brief Get the animation of the throwable_item.
 */
const bear::visual::animation& ptb::throwable_item::get_animation() const
{
  bear::engine::level_globals& glob = m_player->get_level_globals();

  return glob.get_animation("animation/stones/stone.canim");
} // throwable_item::get_animation()

/*----------------------------------------------------------------------------*/
/**
 * \brief Get the name of the object.
 */
std::string
ptb::throwable_item::get_name() const
{
  return "unknown";
} // throwable_item::get_name()
