/*
  Plee the Bear

  Copyright (C) 2005-2010 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file code/on_players_activator.cpp
 * \brief Implementation of the ptb::on_players_activator class.
 * \author Julien Jorge
 */
#include "ptb/item/on_players_activator.hpp"
#include "ptb/player.hpp"
#include "ptb/item_brick/activate_on_players.hpp"

BASE_ITEM_EXPORT( on_players_activator, ptb )

/*----------------------------------------------------------------------------*/
/**
 * \brief Set a field of type \c list of item.
 * \param name The name of the field.
 * \param value The new value of the field.
 * \return false if the field "name" is unknow, true otherwise.
 */
bool ptb::on_players_activator::set_item_list_field
( const std::string& name, const std::vector<bear::engine::base_item*>& value)
{
  bool ok = true;

  if (name == "on_players_activator.item")
    for( std::size_t i=0; i!=value.size(); ++i )
      m_item.push_back( handle_type(value[i]) );
  else
    ok = super::set_item_list_field(name, value);

  return ok;
} // on_players_activator::set_item_list_field()

/*----------------------------------------------------------------------------*/
/**
 * \brief Activation by one player among the two players.
 * \param p The player.
 */
void ptb::on_players_activator::on_one_player( player* p )
{
  handle_list::iterator it;
  std::list<handle_list::iterator> dead;

  for (it=m_item.begin(); it!=m_item.end(); ++it)
    if ( *it == (activate_on_players*)NULL )
      dead.push_back(it);
    else
      (*it)->on_one_player(p);

  for ( ; !dead.empty(); dead.pop_front() )
    m_item.erase(dead.front());
} // on_players_activator::on_one_player()

/*----------------------------------------------------------------------------*/
/**
 * \brief Activation by all players.
 * \param p1 The first player.
 * \param p2 The second player. NULL in a single player game.
 */
void ptb::on_players_activator::on_all_players( player* p1, player* p2 )
{
  handle_list::iterator it;
  std::list<handle_list::iterator> dead;

  for (it=m_item.begin(); it!=m_item.end(); ++it)
    if ( *it == (activate_on_players*)NULL )
      dead.push_back(it);
    else
      (*it)->on_all_players(p1, p2);

  for ( ; !dead.empty(); dead.pop_front() )
    m_item.erase(dead.front());
} // on_players_activator::on_all_players()

/*----------------------------------------------------------------------------*/
/**
 * \brief Get the items concerned by a progress/move of this one.
 * \param d (out) A list to which are added such items.
 */
void ptb::on_players_activator::get_dependent_items
( std::list<bear::universe::physical_item*>& d ) const
{
  super::get_dependent_items(d);

  handle_list::const_iterator it;

  for (it=m_item.begin(); it!=m_item.end(); ++it)
    if ( *it != (physical_item*)NULL )
      d.push_back(it->get_item());
} // on_players_activator::get_dependent_items()
