/*
  Plee the Bear

  Copyright (C) 2005-2010 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file defines.hpp
 * \brief Game definess.
 * \author Julien Jorge
 */
#ifndef __PTB_DEFINES_HPP__
#define __PTB_DEFINES_HPP__

/** \brief The name of the level displayed when loading a level. */
#define PTB_LOADING_LEVEL_NAME "level/loading.cl"

/** \brief The maximum number of points a player can receive at once. */
#define PTB_MAX_POINTS_AT_ONCE 50000

/** \brief The number of points over which the player wins a new try. */
#define PTB_ONE_UP_POINTS_COUNT 50000

/** \brief The name of the layer displaying the transition effects. */
#define PTB_TRANSITION_EFFECT_DEFAULT_TARGET_NAME "transition_effect_layer"

/** \brief The name of the layer displaying the balloons. */
#define PTB_BALLOON_LAYER_DEFAULT_TARGET_NAME "balloon_layer"

/** \brief The name of the layer displaying the frames during the game. */
#define PTB_WINDOWS_LAYER_DEFAULT_TARGET_NAME "windows_layer"

/** \brief The default orange color, used in gui layers. */
#define PTB_ORANGE_PIXEL bear::visual::color_type(254, 160, 0, 255)

/** \brief The name of the file containing the list of unlocked mini-games. */
#define PTB_UNLOCKED_MINI_GAME_FILENAME "mini-game.txt"

/** \brief The name of the file containing the list of unlocked mini-games. */
#define PTB_MINI_GAME_INFORMATIONS "mini-game/informations.txt"

/** \brief The number of record lines for mini-games. */
#define PTB_NUMBER_OF_RECORDS 6

#endif // __PTB_DEFINES_HPP__
