/*
  Bear Engine

  Copyright (C) 2005-2010 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file code/environment_rectangle_creator.cpp
 * \brief Implementation of the bear::environment_rectangle_creator class.
 * \author Sebastien Angibaud
 */
#include "generic_items/environment_rectangle_creator.hpp"

#include "engine/layer/layer.hpp"
#include "engine/world.hpp"

BASE_ITEM_EXPORT( environment_rectangle_creator, bear )

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 */
bear::environment_rectangle_creator::environment_rectangle_creator()
  : m_environment(bear::universe::air_environment)
{
  set_can_move_items(false);
} // environment_rectangle_creator::environment_rectangle_creator()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set a field of type <string>.
 * \param name The name of the field.
 * \param value The value of the field.
 */
bool bear::environment_rectangle_creator::set_string_field
( const std::string& name, const std::string& value )
{
  bool result = true;

  if ( name == "environment_rectangle_creator.environment" )
    {
      if ( value == "air_environment" )
        m_environment = universe::air_environment;
      else if ( value == "fire_environment" )
        m_environment = universe::fire_environment;
      else if ( value == "ice_environment" )
        m_environment = universe::ice_environment;
      else if ( value == "water_environment" )
        m_environment = universe::water_environment;
      else
        result = false;
    }
  else
    result = super::set_string_field(name, value);

  return result;
} // environment_rectangle_creator::set_string_field()

/*----------------------------------------------------------------------------*/
/**
 * \brief Initialize the item.
 */
void bear::environment_rectangle_creator::build()
{
  if ( get_layer().has_world() )
    get_layer().get_world().add_environment_rectangle
      (get_bounding_box(), m_environment);

  kill();
} // environment_rectangle_creator::build()
