/*
  Bear Engine

  Copyright (C) 2005-2010 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file var_map.hpp
 * \brief The structure in which we store the level variables or game variables.
 * \author Julien Jorge
 */
#ifndef __ENGINE_VAR_MAP_HPP__
#define __ENGINE_VAR_MAP_HPP__

#include <claw/multi_type_map.hpp>
#include <claw/meta/type_list.hpp>

#include <string>

namespace bear
{
  namespace engine
  {
    /** \brief The types supported by the engine. */
    typedef claw::meta::type_list_maker
    <int, unsigned int, bool, double, std::string>::result var_types;

    /** \brief The structure in which we store the level variables or game
        variables. */
    typedef claw::multi_type_map<std::string, var_types> var_map;

  } // namespace engine
} // namespace bear

#endif // __ENGINE_VAR_MAP_HPP__
