/*
 *  Player - One Hell of a Robot Server
 *  Copyright (C) Andrew Howard 2003
 *
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*
 * $Id: test_vision.cc 8106 2009-07-23 19:14:37Z thjc $
 *
 * a test for the C++ SonarProxy
 */

#include "test.h"
#include <unistd.h>

int
test_vision(PlayerClient* client, int index)
{
  unsigned char access;
  BlobfinderProxy vp(client,index,'c');

  printf("device [vision] index [%d]\n", index);

  TEST("subscribing (read)");
  if((vp.ChangeAccess(PLAYER_READ_MODE,&access) < 0) ||
     (access != PLAYER_READ_MODE))
  {
    FAIL();
    printf("DRIVER: %s\n", vp.driver_name);
    return -1;
  }
  PASS();
  printf("DRIVER: %s\n", vp.driver_name);

  if(!use_stage)
  {
    // let ACTS start up
    TEST("waiting for ACTS to start up");
    for(int i=0;i<100;i++)
      client->Read();
    puts("done.");
  }

  for(int t = 0; t < 3; t++)
  {
    TEST1("reading data (attempt %d)", t);

    if(client->Read() < 0)
    {
      FAIL();
      return(-1);
    }

    PASS();

    vp.Print();
  }

  TEST("unsubscribing");
  if((vp.ChangeAccess(PLAYER_CLOSE_MODE,&access) < 0) ||
     (access != PLAYER_CLOSE_MODE))
  {
    FAIL();
    return -1;
  }

  PASS();

  return(0);
}

