/*
 *  Copyright 2008 by Alessandro Diaferia <alediaferia@gmail.com>

 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of 
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PREVIEWER_HEADER
#define PREVIEWER_HEADER


#include <QWidget>
#include <QGraphicsLinearLayout>
#include <QGraphicsGridLayout>

#include <Plasma/Applet>
#include <Plasma/Svg>

namespace Plasma{
  class Icon;
  class Dialog;
  class Label;
  class Widget;
}
namespace KParts{
   class ReadOnlyPart;
}

class KMenu;
class QGraphicsSceneDragDropEvent;
class QGraphicsScene;
class QGraphicsView;
class QGraphicsWidget;
//class QGraphicsProxyWidget;
class KUrl;
class QVBoxLayout;
class KPushButton;
class QLabel;
class QToolButton;

// here we define the applet
class Previewer : public Plasma::Applet
{
  Q_OBJECT
   public:
      Previewer(QObject* parent, const QVariantList &args);
      ~Previewer();
      virtual QList<QAction*> contextualActions();
      void init();

    private:
       Plasma::Icon *m_icon;
       QToolButton *close_i;
       QWidget *base;
       KMenu *m_menu;
       Plasma::Dialog *m_dialog;
       KParts::ReadOnlyPart *m_part;
       QGraphicsLinearLayout *lay;
       QVBoxLayout *d_lay;
       bool previewing;
       Plasma::Label *m_label;
       QLabel *mime_icon;
       QGraphicsWidget *icons_base;
       QList<QAction*> actions;

    protected:
      void dropEvent(QGraphicsSceneDragDropEvent *);
      QList<QUrl> previewHistory();

    protected slots:
      virtual void openFile(KUrl u = KUrl());
      virtual void popup();
      virtual void closeFile();
      virtual void showHide();
      virtual void addPreview(const QUrl&);
      virtual void reopenPreview();
      virtual void rePopupForSize(const QSize&);
      virtual void stayOnTop(bool);
};


// This filter should allow the Dialog resize by using the wheel
// hoping not to interfere with the part of the dialog and
// other widgets in it.
class ResizeFilter : public QObject
{
  Q_OBJECT
  public:
     ResizeFilter() : 
        resize(false){}
  private:
   bool resize;

  protected:
     bool eventFilter(QObject *obj, QEvent *event){
      
      QWidget *wdg = qobject_cast<QWidget*>(obj);
      if(wdg){
       if(event->type() == QEvent::Wheel){
         QWheelEvent *whEv = static_cast<QWheelEvent*>(event);
         //kDebug()<<"wheel rolled";
         int wheelDegrees = whEv->delta() / 8;
         int wheelSteps = wheelDegrees / 15;
         wdg->resize(wdg->size()+=QSize(wheelSteps*9, wheelSteps*9));
         return true;

       }else if(event->type() == QEvent::Resize){
        QResizeEvent *rsEv = static_cast<QResizeEvent*>(event);
        emit resized(rsEv->size()); // let's inform about resize to allow the repositioning of the widget
        return false;

       }else if(event->type() == QEvent::MouseMove){
        QMouseEvent *moEv = static_cast<QMouseEvent*>(event);

        wdg->move( wdg->pos()+=moEv->pos() );

        return false;

       }else{
         return false;
       }
      }else{
       return QObject::eventFilter(obj, event);
      }
     }

  signals:
    void resized(const QSize&);   
};

K_EXPORT_PLASMA_APPLET(previewer, Previewer)
#endif
