/***********************************************************************************
* CPU Load: Plasmoid to monitor CPU Load.
* Copyright (C) 2008  Alexey Tyapkin
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
***********************************************************************************/
#include "cpuload.h"
#include <QPainter>
#include <QFontMetrics>
#include <QSizeF>
#include <QBitmap>
#include <QFile>
#include <plasma/svg.h>
#include <plasma/theme.h>

#include <stdio.h>



cpuload::cpuload ( QObject *parent, const QVariantList &args )
		: Plasma::Applet ( parent, args ),
		m_svg ( this ),
		m_icon ( "document" )
{
	iXCount=24;
	iYCount=10;
	iXStep=10;
	iYStep=10;
	iWidth=iXCount*iXStep;
	iHeight=iYCount*iYStep;
	iWidth1=iWidth-2;
	iWidth2=iWidth-4;

/*	QTextStream out(stdout);
	out << "> Prepare to read file:\n";*/
	QFile file ( "/proc/cpuinfo" );
	if ( file.open ( QIODevice::ReadOnly ) )
	{
		//out << ">	file opened\n";
		QTextStream t ( &file );
		QString buf;
	
		while ( (buf=t.readLine()) != NULL )
		{
			/*buf=t.readLine();
			out << buf ;*/
			if ( buf.startsWith ( "model name" ) )
			{
				sCpuModel=buf.split(":")[1];
/*				sCpuModel=buf;
				out << buf;*/
				break;
			}
		}
	}else sCpuModel="";
	if (file.isOpen()) {
		file.close();
	}

	// this will get us the standard applet background, for free!
	setBackgroundHints ( DefaultBackground );
//	setBackgroundHints(Plasma::Applet::NoBackground);

/*    //make background transparent
    QPalette p = palette();
    QColor c = p.color( QPalette::Base );
    c.setAlpha( 0 );
    p.setColor( QPalette::Base, c );
    setPalette( p );
*/
	m_svg.setImagePath ( "widgets/background" );
	resize ( iWidth+iXStep*6+1 +20,iHeight+iYStep*2+1 +20);
}


cpuload::~cpuload()
{
	if ( hasFailedToLaunch() )
	{
		// Do some cleanup here
	}
	else
	{
		// Save settings
	}
}

void cpuload::init()
{
	pm=new QPixmap ( QSize ( iWidth+iXStep*6+1,iHeight+iYStep*2+1 ) );
	dpm=new QPixmap ( QSize ( iWidth+iXStep*6+1,iHeight+iYStep*2+1 ) );
	mask=new QBitmap ( QSize ( iWidth+iXStep*6+1,iHeight+iYStep*2+1 ) );
	pm->fill ( Qt::black );
	dpm->fill ( Qt::black );
	mask->fill ( Qt::color0 );

	QPainter p;

	iCPU=iCPU1=iCPU2=99*iHeight/100;

	iSCPU=iSCPU1=iSCPU2=iHeight;

	iNCPU=iNCPU1=iNCPU2=iHeight;

	iDCPU=iDCPU1=iDCPU2=iHeight;

	userColor=QColor ( 255,0,255 );
	diskColor=QColor ( 0,255,0 );
	niceColor=QColor ( 0,255,255 );
	systemColor=QColor ( 255,255,0 );


	p.begin ( dpm );
	int i=0;
	p.setPen ( Qt::red );
	for ( i=0;i<=iXCount;i++ ) p.drawLine ( i*iXStep,1,i*iXStep,iHeight );
	for ( i=0;i<=iYCount;i++ ) p.drawLine ( 1,i*iYStep,iWidth,i*iYStep );
	
//	p.fillRect ( iWidth+1,1,5*iXStep-1,iHeight, Qt::black );
	p.drawRect(iWidth,0,iXStep*6,iHeight);
	p.drawLine ( iWidth,iHeight/2,iWidth+iXStep*6,iHeight/2 );

	plasmoidFont=p.font();
	plasmoidFont.setBold ( true );
	
	plasmoidFont.setPointSize ( 8 );
	p.setFont ( plasmoidFont );
	p.setPen ( userColor );
	p.drawText ( iWidth+10,13, QString ( "User" ) );
	p.setPen ( systemColor );
	p.drawText ( iWidth+10,23, QString ( "System" ) );
	p.setPen ( niceColor );
	p.drawText ( iWidth+10,33, QString ( "Nice" ) );
	p.setPen ( diskColor );
	p.drawText ( iWidth+10,43, QString ( "Disk" ) );


	plasmoidFont.setBold ( true );
	plasmoidFont.setPointSize ( 20 );
	p.setFont ( plasmoidFont );
	p.setPen ( Qt::white );
	p.drawText ( 0, 0, iWidth, iHeight, Qt::AlignCenter, QString ( "CPU Load" ) );
	plasmoidFont.setPointSize ( 16 );
	p.drawText ( iWidth,iHeight/2,iXStep*6-2,iHeight/2, Qt::AlignRight | Qt::AlignVCenter, "0%");
	plasmoidFont.setPointSize ( 8 );
	p.setFont ( plasmoidFont );
	p.drawText ( 0, iHeight, iWidth+iXStep*6, iYStep*2, Qt::AlignCenter | Qt::TextWordWrap, QString ( sCpuModel ) );

	p.end();


	Plasma::DataEngine *cpu = dataEngine ( "cpuload" );
	cpu->connectSource ( "Average CPU Usage", this, 500 );

}


void cpuload::paintInterface ( QPainter *p,
                               const QStyleOptionGraphicsItem *option, const QRect &contentsRect )
{
	p->setRenderHint ( QPainter::SmoothPixmapTransform );
	p->setRenderHint ( QPainter::Antialiasing );

	// Now we draw the applet, starting with our svg
	m_svg.resize ( ( int ) contentsRect.width(), ( int ) contentsRect.height() );
	m_svg.paint ( p, ( int ) contentsRect.left(), ( int ) contentsRect.top() );

	p->drawPixmap ( 10,10,*dpm );
	p->drawPixmap ( 10,10,*pm );

}

void cpuload::dataUpdated ( const QString& source, const Plasma::DataEngine::Data &data )
{

	if ( source == "0" || source == "Average CPU Usage" )
	{

		/*		m_user = data["User"].toDouble();
				m_sys = data["Sys"].toDouble();
				m_nice = data["Nice"].toDouble();
				m_idle = data["Idle"].toDouble();
				m_disk = data["Disk"].toDouble(); */
		iCPU2=iCPU1;
		iCPU1=iCPU;
		iCPU= (( int ) ( data["Idle"].toDouble() * 100 )) * iHeight/100;

		iSCPU2=iSCPU1;
		iSCPU1=iSCPU;
		iSCPU= iHeight - (( int ) ( data["Sys"].toDouble() * 100 )) * iHeight/100;

		iNCPU2=iNCPU1;
		iNCPU1=iNCPU;
		iNCPU= iHeight - (( int ) ( data["Sys"].toDouble() * 100 ) + ( int ) ( data["Nice"].toDouble() * 100 )) * iHeight/100;

		iDCPU2=iDCPU1;
		iDCPU1=iDCPU;
		iDCPU= iHeight - (( int ) ( data["Sys"].toDouble() * 100 ) + ( int ) ( data["Nice"].toDouble() * 100 ) + ( int ) ( data["Disk"].toDouble() * 100 )) * iHeight/100;

		/*		cpu_values.push_back(cpu_value);
				if (cpu_values.count()>(iXCount*2+1))   cpu_values.pop_front();*/

//		pm->setMask( QBitmap () );
		QPixmap tmp=QPixmap ( *pm );
		QPainter p;

		p.begin ( pm );
		p.drawPixmap ( -2,0,tmp );
		p.fillRect ( iWidth-2,0,iWidth,iHeight, Qt::black );


		if ( cpuload::test ( iSCPU,iSCPU1, iSCPU2, iNCPU, iNCPU1, iNCPU2 ) )
		{
			cpuNiceGraph = QPainterPath() ;
			p.setPen ( QPen ( niceColor, 1 ) );
			cpuNiceGraph.moveTo ( QPointF ( iWidth2, iNCPU2 ) ) ;
			cpuNiceGraph.lineTo ( iWidth1, iNCPU1 ) ;
			cpuNiceGraph.lineTo ( iWidth, iNCPU ) ;
			p.drawPath ( cpuNiceGraph ) ;
		}


		if ( cpuload::test ( iNCPU, iNCPU1, iNCPU2, iDCPU, iDCPU1, iDCPU2 ) )
		{
			cpuDiskGraph = QPainterPath() ;
			p.setPen ( QPen ( diskColor, 1 ) );
			cpuDiskGraph.moveTo ( QPointF ( iWidth2, iDCPU2 ) ) ;
			cpuDiskGraph.lineTo ( iWidth1, iDCPU1 ) ;
			cpuDiskGraph.lineTo ( iWidth, iDCPU ) ;
			p.drawPath ( cpuDiskGraph ) ;
		}

		cpuSysGraph = QPainterPath() ;
		p.setPen ( QPen ( systemColor, 1 ) );
		cpuSysGraph.moveTo ( QPointF ( iWidth2, iSCPU2 ) ) ;
		cpuSysGraph.lineTo ( iWidth1, iSCPU1 ) ;
		cpuSysGraph.lineTo ( iWidth, iSCPU ) ;
		p.drawPath ( cpuSysGraph ) ;

		cpuGraph = QPainterPath() ;
		p.setPen ( QPen ( userColor, 1 ) );
		cpuGraph.moveTo ( QPointF ( iWidth2, iCPU2 ) ) ;
		cpuGraph.lineTo ( iWidth1, iCPU1 ) ;
		cpuGraph.lineTo ( iWidth, iCPU ) ;
		p.drawPath ( cpuGraph ) ;
		p.end();

		QBitmap tmpMask=QBitmap ( *mask );
		mask->fill ( Qt::color0 );
		p.begin ( mask );
		p.drawPixmap ( -2,0,tmpMask );
		p.fillRect ( iWidth-2,0,iWidth,iHeight, Qt::color0 );
		p.setPen ( QPen ( Qt::color1,1 ) );


		if ( cpuload::test ( iSCPU,iSCPU1, iSCPU2, iNCPU, iNCPU1, iNCPU2 ) )
		{
			p.drawPath ( cpuNiceGraph ) ;
		}
		if ( cpuload::test ( iNCPU, iNCPU1, iNCPU2, iDCPU, iDCPU1, iDCPU2 ) )
		{
			p.drawPath ( cpuDiskGraph ) ;
		}
		p.drawPath ( cpuSysGraph ) ;
		p.drawPath ( cpuGraph ) ;
		p.end();

		pm->setMask ( *mask );

		p.begin(dpm);
		p.fillRect ( iWidth+1,iHeight/2+1,6*iXStep-2,iHeight/2-2, Qt::black );
		plasmoidFont.setBold ( true );
		plasmoidFont.setPointSize ( 16 );
		p.setFont(plasmoidFont);
		p.setPen ( Qt::white );
		p.drawText ( iWidth,iHeight/2,iXStep*6-2,iHeight/2, Qt::AlignRight | Qt::AlignVCenter, data["iLoad"].toString()+"%");
		
		p.end();

		update();

	}
}


#include "cpuload.moc"
