/******************************************************************************
*                             plasma-am4rok                                   *
*******************************************************************************
*                                                                             *
*            Copyright (C) 2008 Giulio Camuffo				      *                             *									      *
*                                                                             *
*                                                                             *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with this program; if not, write to the Free Software               *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA  *
*                                                                             *
*                                                                             *
*                                                                             *
*   For further information contact me at giuliocamuffo@gmail.com	      *
******************************************************************************/

#ifndef PLAYER_CONTROLLER_H
#define PLAYER_CONTROLLER_H


#include <QString>
#include <QTimer>

class PlayerController : public QObject
{
  Q_OBJECT

  public:
    PlayerController();
    ~PlayerController();

    int playerIntQuery(const QString &query);
    QString playerStringQuery(const QString &query);
    int playlistIntQuery(const QString &query);
    QString playlistStringQuery(const QString &query);
    void playerQuery(const QString &query);
    void playerQuery(const QString &query, const int &);
    QString playerTimeQuery(void);
    QString playerTrackQuery(void);
    void updateInfos(void);
    void forceUpdateInfos(void);
    void setPlayer(int &player);
    int player(void);
    QString upFirstLetter(const QString &string);

  public slots:
    void changeState(const QString &state);
    void playerStatus(void);


  signals:
    void timeChanged(const QString &time);
    void intTimeChanged(const int &time);
    void titleChanged(const QString &title);
    void artistChanged(const QString &artist);
    void albumChanged(const QString &album);
    void trackChanged(const QString &track);
    void statusChanged(const QString &status);

  private:
    QTimer timer;
    int m_player;
    int m_status;
    int m_intTime;
    QString m_time;
    QString m_artist;
    QString m_album;
    QString m_title;
    QString m_track;

    void stopped(void);
};

#endif
