/******************************************************************************
*                             plasma-am4rok                                   *
*******************************************************************************
*                                                                             *
*            Copyright (C) 2008 Giulio Camuffo				      *                             *									      *
*                                                                             *
*                                                                             *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with this program; if not, write to the Free Software               *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA  *
*                                                                             *
*                                                                             *
*                                                                             *
*   For further information contact me at giuliocamuffo@gmail.com	      *
******************************************************************************/

#include "mmlabel.h"

MyQLabel::MyQLabel(QWidget *parent)
    : QLabel(parent)
{

}

MyQLabel::~MyQLabel(void)
{

}

void MyQLabel::mousePressEvent(QMouseEvent *event)
{
    if (event->buttons () == Qt::LeftButton)
	emit clicked();
    else
	event->ignore();
}

///-------------------------------------------------------------------------

MMLabel::MMLabel(QWidget *parent)
    : QWidget(parent)
{

    label = new MyQLabel(this);
    label->setAttribute( Qt::WA_NoSystemBackground );
    setAttribute( Qt::WA_NoSystemBackground );
    label->setAlignment(Qt::AlignCenter);

    direction = STOPPED;

    connect(label, SIGNAL(clicked()), this,SIGNAL(clicked()));

    label->show();
    show();
}

MMLabel::~MMLabel(){
    delete label;
    timer.stop();
}

void MMLabel::moveString(void){
  double margin = size().width() - label->size().width();

  if (direction == STOPPED){
  	direction = LEFT;
  	return;
  }
  
    if ((direction == RIGHT) and (label->geometry().x() < 0))
    {
  	label->setGeometry(QRect(label->geometry().x()+1,
  							  label->geometry().y(), 
  							  label->geometry().width(), 
  							  label->geometry().height()));  
  	return;	
    }
  
  if ((direction == RIGHT) and (label->geometry().x() >= 0)){
  	direction = LEFT;
  	return;
  }
  
  if ((direction == LEFT) and (label->geometry().x() > margin)){
  	label->setGeometry(QRect(label->geometry().x()-1,
  							  label->geometry().y(), 
  							  label->geometry().width(), 
  							  label->geometry().height()));  
  	return;	
  }
  
  if ((direction == LEFT) and (label->geometry().x() <= margin)){
  	direction = RIGHT;
  	return;
  }  
}

void MMLabel::setText(const QString &text){
    label->setFont(QFont("Helvetica", 7, QFont::Bold));
    QString textTemplate = tr("<font color='%1'>%2</font>"); //sets the color 
    label->setText(textTemplate.arg(color, text));	     //of the text
    label->adjustSize();
    timer.stop();
    if (label->size().width() > size().width()){
// 	label->setGeometry(x(),y(),m_rect.width(),m_rect.height());
	if (scrollString){
	    timer.connect(&timer,SIGNAL(timeout(void)),
	    this,SLOT(moveString(void)));
	    timer.start(500);
	}
	else
	    adjustFonts();
    }
    else
        centerLabel();


}

void MMLabel::centerLabel(void)
{
    double pos = (size().width() - label->size().width())/2.0;
    label->setGeometry(QRect(pos,0,label->size().width(),label->size().height()));
}

void MMLabel::adjustFonts(void)
{
    if (label->size().width() > size().width()){
	label->setFont(QFont("Helvetica",label->font().pointSize()-0.5, QFont::Bold));
	label->adjustSize();
	adjustFonts();
    }
    centerLabel();
}

QString MMLabel::text(void) const{
 	return label->text();
}

void MMLabel::setColor(const QColor &colorToSet){
    color = colorToSet.name();
}

void MMLabel::setFont(const QFont &font){
	label->setFont(font);
}

QFont MMLabel::font(void) const{
	return label->font();
}

void MMLabel::setAlignment(Qt::Alignment align){
	label->setAlignment(align);
}

void MMLabel::setScrollStrings(const bool value){
    if (scrollString != value){
	scrollString = value;
	setText(label->text());
    }
}

bool MMLabel::getScrollStrings(void) const{
    return scrollString;
}

void MMLabel::resizeEvent(QResizeEvent *)
{
    setText(label->text());
}

void MMLabel::mousePressEvent(QMouseEvent *event)
{
    if (event->buttons () == Qt::LeftButton)
	emit clicked();
    else
	event->ignore();
}

#include "mmlabel.moc"
