/******************************************************************************
*                             plasma-am4rok                                   *
*******************************************************************************
*                                                                             *
*            Copyright (C) 2008 Giulio Camuffo				      *                             *									      *
*                                                                             *
*                                                                             *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with this program; if not, write to the Free Software               *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA  *
*                                                                             *
*                                                                             *
*                                                                             *
*   For further information contact me at giuliocamuffo@gmail.com	      *
******************************************************************************/

#include "mminfowidget.h"

MMInfoWidget::MMInfoWidget(Plasma::Applet *parent): 
    QGraphicsWidget(parent)
{
    parentApplet = parent;

    controlWidget= new MMButtonWidget(this);
    pbar = new MMProgressBar(this);
    proxyInfos = new QGraphicsProxyWidget(this);
    infos = new MMInfoDisplay();
    proxyInfos->setWidget(infos);
    proxyInfos->setAttribute(Qt::WA_NoSystemBackground);

    t_layout = new QGraphicsLinearLayout(this);
    t_layout->setOrientation(Qt::Vertical);
    t_layout->setSpacing(0);
    setLayout(t_layout);

    proxyInfos->setZValue(5);
    controlWidget->setZValue(10);

    isDialogCreated = false;

    connect(infos, SIGNAL(clicked()),
            this,SLOT(toggleDialogIsVisible()));
    connect(controlWidget, SIGNAL(clicked()),
            this,SLOT(toggleDialogIsVisible()));
}

MMInfoWidget::~MMInfoWidget(){
  //  delete t_layout;
    delete controlWidget;
    delete pbar;
    proxyInfos->setWidget(0);
    delete infos;
    delete proxyInfos;
}

void MMInfoWidget::setContentSize(int x, int y)
{
    setContentSize(QSizeF(x,y));
}

void MMInfoWidget::setContentSize(QSizeF size)
{
    t_width = size.width();
    t_height = size.height();

    setMinimumSize(t_width,t_height);		// I really can't
    setMaximumSize(t_width,t_height);		// understand why calling
    t_layout->setMinimumSize(t_width,t_height); // setGeometry(QRectF) or resize(QSizeF)
    t_layout->setMaximumSize(t_width,t_height);	// gives no result

    recalculateGeometry();
}

QSizeF MMInfoWidget::contentSizeHint(void) const{
  return QSizeF(t_width, t_height);
}

void MMInfoWidget::recalculateGeometry(void){

    while (t_layout->count() != 0)
	t_layout->removeAt(0);


    if(isOnPanel){
	if (showStrings)
	{
	    proxyInfos->show();
	    t_layout->addItem(proxyInfos);
	    controlWidget->hide();
	    controlWidget->resize(100,30);
	    controlWidget->setPos((t_width/2.0)-(controlWidget->size().width()/2),(t_height/2.0)-(controlWidget->size().height()/2.0));
	    pbar->setMaxHeight(6);
	}
	else 
	{
	    controlWidget->show();
	    t_layout->addItem(controlWidget);
	    proxyInfos->hide();
	    pbar->setMaxHeight(t_height/4.0);
	}

	if (not isDialogCreated){
	    isDialogCreated = true;

	    dialog = new MMInfoDialog();
	    dialog->resize(250,200);
	    setCloseDialogOnFocusOut(closeDialogOnFocusOut);
	}

	t_layout->setContentsMargins(0,0,0,0);
    }
    else
    {
	t_layout->addItem(proxyInfos);
    	t_layout->addItem(controlWidget);
	t_layout->setContentsMargins(13,13,0,0);
    }
    t_layout->addItem(pbar);

    infos->setIsOnPanel(isOnPanel,t_height<50.0);
}

QSize MMInfoWidget::getDialogSize(void) const
{
    if (dialog)
	return dialog->sizeHint();

    return QSize(0,0);
}

void MMInfoWidget::toggleDialogIsVisible()
{
    if (isDialogCreated)
    {
	if (dialog->isVisible())
	    dialog->hide();
	else
	{
	    dialog->show();
	    dialog->move(parentApplet->popupPosition(dialog->size()));
	}
    }
}

void MMInfoWidget::setIsOnPanel(bool value)
{
    isOnPanel = value;
}

void MMInfoWidget::setCloseDialogOnFocusOut(bool value)
{
  if (isDialogCreated){
    if (value)
      dialog->setWindowFlags(Qt::Popup);
    else
      dialog->setWindowFlags(Qt::X11BypassWindowManagerHint);
  }
  closeDialogOnFocusOut = value;
}

bool MMInfoWidget::getCloseDialogOnFocusOut(void) const
{
    return closeDialogOnFocusOut;
}

void MMInfoWidget::setDialogTextColor(QColor color)
{
  if (isDialogCreated)
    dialog->setTextColor(color);
}

void MMInfoWidget::setTextColor(QColor color)
{
    infos->setTextColor(color);
}

void MMInfoWidget::setScrollStrings(bool scrollStrings)
{
    infos->setScrollStrings(scrollStrings);
}

bool MMInfoWidget::getScrollStrings(void) const{
  return infos->getScrollStrings();
}

void MMInfoWidget::setPlayer(int pl){
  player = pl;
}

void MMInfoWidget::setShowStrings(bool value){
  showStrings = value;
}

void MMInfoWidget::updateTitle(const QString &value){
    infos->setTitle(value);
    if (isDialogCreated)
	dialog->setTitle(value);
}

void MMInfoWidget::updateAlbum(const QString &value){
    infos->setAlbum(value);
    if (isDialogCreated)
	dialog->setAlbum(value);
}

void MMInfoWidget::updateArtist(const QString &value){
    infos->setArtist(value);
    if (isDialogCreated)
	dialog->setArtist(value);
}

void MMInfoWidget::updateTime(const QString &value){
    infos->setTime(value);
    if (isDialogCreated)
	dialog->setTime(value);
}

void MMInfoWidget::updateTrack(const QString &value){
    infos->setTrack(value);
    if (isDialogCreated)
	dialog->setTrack(value);
}

void MMInfoWidget::updateBar(const int &value){
    pbar->setValue(value);
}

void MMInfoWidget::updateStatus(const QString &status){
  controlWidget->setStatus(status);
}

QColor MMInfoWidget::getDialogTextColor(void) const{
  //return dialogTextColor;
    return QColor();
}

QColor MMInfoWidget::getTextColor(void) const{
    return infos->getTextColor();
}

MMProgressBar *MMInfoWidget::progressBarObj(void){
  return pbar;
}

MMButtonWidget *MMInfoWidget::controlWidgetObj(void){
  return controlWidget;
}

#include "mminfowidget.moc"
