/******************************************************************************
*                             plasma-am4rok                                   *
*******************************************************************************
*                                                                             *
*            Copyright (C) 2008 Giulio Camuffo				      *
*	     Copyright (C) 2008 John Varouhakis                               *
*                                                                             *
*                                                                             *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with this program; if not, write to the Free Software               *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA  *
*                                                                             *
*                                                                             *
*                                                                             *
*   For further information contact me at giuliocamuffo@gmail.com	      *
******************************************************************************/

/* 25/03/2008 , author Giulio Camuffo 
added some useful methods*/

#include "mminfodialog.h"

#include <QColor>

MMInfoDialog::MMInfoDialog(QWidget *parent,
                           Qt::WindowFlags f)
    :Plasma::Dialog(parent,f){

    infoWidget = new MMInfoDisplay(this);
    m_lay=new QVBoxLayout(this);
    setLayout(m_lay);
    m_lay->addWidget(infoWidget);
    
    infoWidget->setIsOnPanel(false,false);

}

MMInfoDialog::~MMInfoDialog(void)
{
    delete infoWidget;
    delete m_lay;
}

void MMInfoDialog::setTime(const QString &time){
    infoWidget->setTime(time);
}

void MMInfoDialog::setTitle(const QString &title){
    infoWidget->setTitle(title);	
}

void MMInfoDialog::setArtist(const QString &artist){
    infoWidget->setArtist(artist);
}

void MMInfoDialog::setAlbum(const QString &album){
    infoWidget->setAlbum(album);
}

void MMInfoDialog::setTrack(const QString &track){
    infoWidget->setTrack(track);
}

void MMInfoDialog::setTextColor(QColor color){
    infoWidget->setTextColor(color);
}


#include <mminfodialog.moc>
